/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.ModifyInterceptor;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.DroolsMVELShadowFactory;
import org.drools.base.mvel.MVELCalendarCoercion;
import org.drools.base.mvel.MVELDateCoercion;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.rule.Declaration;
import org.drools.runtime.rule.RuleContext;
import org.drools.spi.KnowledgeHelper;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;

public class MVELCompilationUnit
implements Externalizable {
    private String name;
    private String expression;
    private String[] pkgImports;
    private String[] importClasses;
    private String[] importMethods;
    private String[] importFields;
    private String[] globalIdentifiers;
    private Declaration[] previousDeclarations;
    private Declaration[] localDeclarations;
    private String[] otherIdentifiers;
    private String[] inputIdentifiers;
    private String[] inputTypes;
    private String[] shadowIdentifiers;
    private int languageLevel;
    private boolean strictMode;
    private Map<String, Class> resolvedInputs;
    private static Map interceptors = new HashMap(2);
    private static final Map<String, Class> primitivesMap;
    public static final Object COMPILER_LOCK;

    static {
        interceptors.put("Modify", new ModifyInterceptor());
        DataConversion.addConversionHandler(Date.class, (ConversionHandler)new MVELDateCoercion());
        DataConversion.addConversionHandler(Calendar.class, (ConversionHandler)new MVELCalendarCoercion());
        primitivesMap = new HashMap<String, Class>();
        primitivesMap.put("int", Integer.TYPE);
        primitivesMap.put("boolean", Boolean.TYPE);
        primitivesMap.put("float", Float.TYPE);
        primitivesMap.put("long", Long.TYPE);
        primitivesMap.put("short", Short.TYPE);
        primitivesMap.put("byte", Byte.TYPE);
        primitivesMap.put("double", Double.TYPE);
        primitivesMap.put("char", Character.TYPE);
        COMPILER_LOCK = new Object();
    }

    public MVELCompilationUnit() {
    }

    public MVELCompilationUnit(String name, String expression, String[] pkgImports, String[] importClasses, String[] importMethods, String[] importFields, String[] globalIdentifiers, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] otherIdentifiers, String[] inputIdentifiers, String[] inputTypes, int languageLevel, boolean strictMode) {
        this.name = name;
        this.expression = expression;
        this.pkgImports = pkgImports;
        this.importClasses = importClasses;
        this.importMethods = importMethods;
        this.importFields = importFields;
        this.globalIdentifiers = globalIdentifiers;
        this.previousDeclarations = previousDeclarations;
        this.localDeclarations = localDeclarations;
        this.otherIdentifiers = otherIdentifiers;
        this.inputIdentifiers = inputIdentifiers;
        this.inputTypes = inputTypes;
        this.languageLevel = languageLevel;
        this.strictMode = strictMode;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setShadowIdentifiers(String[] shadowIdentifiers) {
        this.shadowIdentifiers = shadowIdentifiers;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.expression);
        out.writeObject(this.pkgImports);
        out.writeObject(this.importClasses);
        out.writeObject(this.importMethods);
        out.writeObject(this.importFields);
        out.writeObject(this.globalIdentifiers);
        out.writeObject(this.previousDeclarations);
        out.writeObject(this.localDeclarations);
        out.writeObject(this.otherIdentifiers);
        out.writeObject(this.inputIdentifiers);
        out.writeObject(this.inputTypes);
        out.writeObject(this.shadowIdentifiers);
        out.writeInt(this.languageLevel);
        out.writeBoolean(this.strictMode);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.expression = in.readUTF();
        this.pkgImports = (String[])in.readObject();
        this.importClasses = (String[])in.readObject();
        this.importMethods = (String[])in.readObject();
        this.importFields = (String[])in.readObject();
        this.globalIdentifiers = (String[])in.readObject();
        this.previousDeclarations = (Declaration[])in.readObject();
        this.localDeclarations = (Declaration[])in.readObject();
        this.otherIdentifiers = (String[])in.readObject();
        this.inputIdentifiers = (String[])in.readObject();
        this.inputTypes = (String[])in.readObject();
        this.shadowIdentifiers = (String[])in.readObject();
        this.languageLevel = in.readInt();
        this.strictMode = in.readBoolean();
    }

    public Serializable getCompiledExpression(ClassLoader classLoader) {
        int n;
        HashMap<String, AnnotatedElement> resolvedImports = new HashMap<String, AnnotatedElement>(this.importClasses.length + this.importMethods.length + this.importFields.length);
        String lastName = null;
        try {
            Class cls;
            String className;
            String name;
            String[] stringArray = this.importClasses;
            n = this.importClasses.length;
            int n2 = 0;
            while (n2 < n) {
                lastName = name = stringArray[n2];
                Class cls2 = this.loadClass(classLoader, name);
                resolvedImports.put(cls2.getSimpleName(), cls2);
                ++n2;
            }
            stringArray = this.importMethods;
            n = this.importMethods.length;
            n2 = 0;
            while (n2 < n) {
                lastName = name = stringArray[n2];
                int lastDot = name.lastIndexOf(46);
                className = name.substring(0, lastDot);
                cls = this.loadClass(classLoader, className);
                String methodName = name.substring(lastDot + 1);
                Method method = null;
                Method[] methodArray = cls.getMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method item = methodArray[n4];
                    if (methodName.equals(item.getName())) {
                        method = item;
                    }
                    ++n4;
                }
                resolvedImports.put(method.getName(), method);
                ++n2;
            }
            stringArray = this.importFields;
            n = this.importFields.length;
            n2 = 0;
            while (n2 < n) {
                name = stringArray[n2];
                int lastDot = name.lastIndexOf(46);
                className = name.substring(0, lastDot);
                cls = this.loadClass(classLoader, className);
                String fieldName = name.substring(lastDot + 1);
                Field field = cls.getField(fieldName);
                resolvedImports.put(field.getName(), field);
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeDroolsException("Unable to resolve import '" + lastName + "'");
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeDroolsException("Unable to resolve import '" + lastName + "'");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new RuntimeDroolsException("Unable to resolve import '" + lastName + "'");
        }
        ParserContext parserContext = new ParserContext(resolvedImports, null, this.name);
        parserContext.getParserConfiguration().setClassLoader(classLoader);
        String[] lastDot = this.pkgImports;
        int n5 = this.pkgImports.length;
        n = 0;
        while (n < n5) {
            String pkgImport = lastDot[n];
            parserContext.addPackageImport(pkgImport);
            ++n;
        }
        parserContext.setInterceptors(interceptors);
        parserContext.setStrongTyping(this.strictMode);
        this.resolvedInputs = new HashMap<String, Class>(this.inputIdentifiers.length);
        parserContext.addInput("drools", KnowledgeHelper.class);
        this.resolvedInputs.put("drools", KnowledgeHelper.class);
        String lastIdentifier = null;
        String lastType = null;
        try {
            int i = 0;
            int length = this.inputIdentifiers.length;
            while (i < length) {
                lastIdentifier = this.inputIdentifiers[i];
                lastType = this.inputTypes[i];
                Class cls = this.loadClass(classLoader, this.inputTypes[i]);
                this.resolvedInputs.put(this.inputIdentifiers[i], cls);
                parserContext.addInput(this.inputIdentifiers[i], cls);
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeDroolsException("Unable to resolve class '" + lastType + "' for identifier '" + lastIdentifier);
        }
        if (parserContext.getInputs().get("kcontext") == null) {
            parserContext.addInput("kcontext", RuleContext.class);
            this.resolvedInputs.put("kcontext", RuleContext.class);
        }
        return this.compile(this.expression, classLoader, parserContext, this.languageLevel);
    }

    public DroolsMVELFactory getFactory() {
        int n;
        HashMap<String, Class> resolvedGlobals = null;
        if (this.inputIdentifiers != null) {
            resolvedGlobals = new HashMap<String, Class>(this.inputIdentifiers.length);
            int i = 0;
            int length = this.globalIdentifiers.length;
            while (i < length) {
                String identifier = this.globalIdentifiers[i];
                resolvedGlobals.put(identifier, this.resolvedInputs.get(identifier));
                ++i;
            }
        }
        HashMap<String, Declaration> previousDeclarationsMap = null;
        if (this.previousDeclarations != null) {
            previousDeclarationsMap = new HashMap<String, Declaration>(this.previousDeclarations.length);
            Declaration[] declarationArray = this.previousDeclarations;
            n = this.previousDeclarations.length;
            int identifier = 0;
            while (identifier < n) {
                Declaration declr = declarationArray[identifier];
                previousDeclarationsMap.put(declr.getIdentifier(), declr);
                ++identifier;
            }
        }
        HashMap<String, Declaration> localDeclarationsMap = null;
        if (this.localDeclarations != null) {
            localDeclarationsMap = new HashMap<String, Declaration>(this.localDeclarations.length);
            Declaration[] declarationArray = this.localDeclarations;
            int n2 = this.localDeclarations.length;
            n = 0;
            while (n < n2) {
                Declaration declr = declarationArray[n];
                localDeclarationsMap.put(declr.getIdentifier(), declr);
                ++n;
            }
        }
        DroolsMVELFactory factory = null;
        if (this.shadowIdentifiers == null) {
            factory = new DroolsMVELFactory(previousDeclarationsMap, localDeclarationsMap, resolvedGlobals, this.inputIdentifiers);
        } else {
            HashSet<String> set = new HashSet<String>(this.shadowIdentifiers.length);
            String[] stringArray = this.shadowIdentifiers;
            int n3 = this.shadowIdentifiers.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                set.add(string);
                ++n4;
            }
            factory = new DroolsMVELShadowFactory(previousDeclarationsMap, localDeclarationsMap, resolvedGlobals, this.inputIdentifiers, set);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable compile(String text, ClassLoader classLoader, ParserContext parserContext, int languageLevel) {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        ExpressionCompiler compiler = new ExpressionCompiler(text.trim());
        if (MVELDebugHandler.isDebugMode()) {
            parserContext.setDebugSymbols(true);
        }
        Object object = COMPILER_LOCK;
        synchronized (object) {
            ClassLoader tempClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            AbstractParser.setLanguageLevel((int)languageLevel);
            CompiledExpression expr = null;
            try {
                expr = compiler.compile(parserContext);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tempClassLoader);
            }
            return expr;
        }
    }

    private Class loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        Class<?> cls = primitivesMap.get(className);
        if (cls == null) {
            cls = classLoader.loadClass(className);
        }
        return cls;
    }
}

