/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.field;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import org.drools.RuntimeDroolsException;
import org.drools.common.DroolsObjectInputStream;
import org.drools.core.util.MathUtils;
import org.drools.spi.FieldValue;

public class ObjectFieldImpl
implements FieldValue,
Externalizable {
    private static final long serialVersionUID = 400L;
    private Object value;
    private boolean isEnum;
    private String enumName;
    private String fieldName;
    private transient boolean isCollection;
    private transient boolean isNumber;
    private transient boolean isBoolean;
    private transient boolean isCharacter;
    private transient boolean isString;

    public ObjectFieldImpl() {
        this(null);
    }

    public ObjectFieldImpl(Object value) {
        this.value = value;
        this.isEnum = value instanceof Enum;
        this.setBooleans();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.isEnum = in.readBoolean();
        this.enumName = (String)in.readObject();
        this.fieldName = (String)in.readObject();
        if (!this.isEnum || this.enumName == null || this.fieldName == null) {
            this.value = (Serializable)in.readObject();
        } else {
            this.resolveEnumValue((DroolsObjectInputStream)in);
        }
        this.setBooleans();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isEnum);
        out.writeObject(this.enumName);
        out.writeObject(this.fieldName);
        if (!this.isEnum || this.enumName == null || this.fieldName == null) {
            out.writeObject(this.value);
        }
    }

    private void resolveEnumValue(DroolsObjectInputStream in) {
        try {
            ClassLoader loader = in.getClassLoader();
            Class<?> staticClass = Class.forName(this.enumName, true, loader);
            this.value = (Serializable)staticClass.getField(this.fieldName).get(null);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Error deserializing enum value " + this.enumName + "." + this.fieldName + " : " + e.getMessage());
        }
    }

    private void setBooleans() {
        this.isCollection = this.value instanceof Collection;
        this.isNumber = this.value instanceof Number;
        this.isBoolean = this.value instanceof Boolean;
        this.isCharacter = this.value instanceof Character;
        this.isString = this.value instanceof String;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    public boolean getBooleanValue() {
        if (this.isBoolean) {
            return (Boolean)this.value;
        }
        if (this.isString) {
            return Boolean.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to boolean not supported for type: " + this.value.getClass());
    }

    public byte getByteValue() {
        if (this.isNumber) {
            return ((Number)this.value).byteValue();
        }
        if (this.isString) {
            return Byte.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to byte not supported for type: " + this.value.getClass());
    }

    public char getCharValue() {
        if (this.isCharacter) {
            return ((Character)this.value).charValue();
        }
        if (this.isString && ((String)this.value).length() == 1) {
            return ((String)this.value).charAt(0);
        }
        throw new RuntimeDroolsException("Conversion to char not supported for type: " + this.value.getClass());
    }

    public double getDoubleValue() {
        if (this.isNumber) {
            return ((Number)this.value).doubleValue();
        }
        if (this.isString) {
            return Double.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to double not supported for type: " + this.value.getClass());
    }

    public float getFloatValue() {
        if (this.isNumber) {
            return ((Number)this.value).floatValue();
        }
        if (this.isString) {
            return Float.valueOf((String)this.value).floatValue();
        }
        throw new RuntimeDroolsException("Conversion to float not supported for type: " + this.value.getClass());
    }

    public int getIntValue() {
        if (this.isNumber) {
            return ((Number)this.value).intValue();
        }
        if (this.isString) {
            return Integer.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to int not supported for type: " + this.value.getClass());
    }

    public long getLongValue() {
        if (this.isNumber) {
            return ((Number)this.value).longValue();
        }
        if (this.isString) {
            return Long.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to long not supported for type: " + this.value.getClass());
    }

    public short getShortValue() {
        if (this.isNumber) {
            return ((Number)this.value).shortValue();
        }
        if (this.isString) {
            return Short.valueOf((String)this.value);
        }
        throw new RuntimeDroolsException("Conversion to short not supported for type: " + this.value.getClass());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ObjectFieldImpl)) {
            return false;
        }
        ObjectFieldImpl other = (ObjectFieldImpl)object;
        return this.value == null && other.value == null || this.value != null && this.value.equals(other.value);
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isBooleanField() {
        return false;
    }

    public boolean isFloatNumberField() {
        return false;
    }

    public boolean isIntegerNumberField() {
        return false;
    }

    public boolean isObjectField() {
        return true;
    }

    public boolean isCollectionField() {
        return this.isCollection;
    }

    public boolean isStringField() {
        return this.isString;
    }

    public BigDecimal getBigDecimalValue() {
        return MathUtils.getBigDecimal(this.value);
    }

    public BigInteger getBigIntegerValue() {
        return MathUtils.getBigInteger(this.value);
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public String getEnumName() {
        return this.enumName;
    }

    public void setEnumName(String enumName) {
        this.enumName = enumName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
}

