/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemoryActions;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.LogicalDependency;
import org.drools.core.util.LinkedList;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.process.instance.ProcessInstance;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.runtime.ExitPoint;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.NodeInstanceContainer;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.spi.Activation;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ProcessContext;
import org.drools.spi.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultKnowledgeHelper
implements KnowledgeHelper,
Externalizable {
    private static final long serialVersionUID = 400L;
    private Rule rule;
    private GroupElement subrule;
    private Activation activation;
    private Tuple tuple;
    private InternalWorkingMemoryActions workingMemory;
    private IdentityHashMap<Object, FactHandle> identityMap;
    private LinkedList previousJustified;

    public DefaultKnowledgeHelper() {
    }

    public DefaultKnowledgeHelper(WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.identityMap = new IdentityHashMap();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rule = (Rule)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.activation = (Activation)in.readObject();
        this.tuple = (Tuple)in.readObject();
        this.workingMemory = (InternalWorkingMemoryActions)in.readObject();
        this.identityMap = (IdentityHashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeObject(this.activation);
        out.writeObject(this.tuple);
        out.writeObject(this.workingMemory);
        out.writeObject(this.identityMap);
    }

    @Override
    public void setActivation(Activation agendaItem) {
        this.rule = agendaItem.getRule();
        this.subrule = agendaItem.getSubRule();
        this.activation = agendaItem;
        this.tuple = agendaItem.getTuple();
    }

    @Override
    public void reset() {
        this.rule = null;
        this.subrule = null;
        this.activation = null;
        this.tuple = null;
        this.identityMap.clear();
        this.previousJustified = null;
    }

    @Override
    public void insert(Object object) throws FactException {
        this.insert(object, false);
    }

    @Override
    public void insert(Object object, boolean dynamic) throws FactException {
        FactHandle handle = this.workingMemory.insert(object, dynamic, false, this.rule, this.activation);
        this.getIdentityMap().put(object, handle);
    }

    @Override
    public void insertLogical(Object object) throws FactException {
        this.insertLogical(object, false);
    }

    @Override
    public void insertLogical(Object object, boolean dynamic) throws FactException {
        if (this.previousJustified == null) {
            this.previousJustified = this.activation.getLogicalDependencies();
            this.activation.setLogicalDependencies(null);
        }
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            dep = (LogicalDependency)this.previousJustified.getFirst();
            while (dep != null) {
                if (object.equals(((InternalFactHandle)dep.getFactHandle()).getObject())) {
                    this.previousJustified.remove(dep);
                    break;
                }
                dep = (LogicalDependency)dep.getNext();
            }
        }
        if (dep != null) {
            this.activation.addLogicalDependency(dep);
        } else {
            FactHandle handle = this.workingMemory.insert(object, dynamic, true, this.rule, this.activation);
            this.getIdentityMap().put(object, handle);
        }
    }

    @Override
    public void cancelRemainingPreviousLogicalDependencies() {
        if (this.previousJustified != null) {
            LogicalDependency dep = (LogicalDependency)this.previousJustified.getFirst();
            while (dep != null) {
                this.workingMemory.getTruthMaintenanceSystem().removeLogicalDependency(this.activation, dep, this.activation.getPropagationContext());
                dep = (LogicalDependency)dep.getNext();
            }
        }
    }

    @Override
    public void update(FactHandle handle, Object newObject) throws FactException {
        ((InternalWorkingMemoryEntryPoint)((InternalFactHandle)handle).getEntryPoint()).update(handle, newObject, this.rule, this.activation);
        this.getIdentityMap().put(newObject, handle);
    }

    @Override
    public void update(Object object) throws FactException {
        FactHandle handle = this.getFactHandle(object);
        if (handle == null) {
            throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        this.update(handle, object);
    }

    @Override
    public void retract(FactHandle handle) throws FactException {
        ((InternalWorkingMemoryEntryPoint)((InternalFactHandle)handle).getEntryPoint()).retract(handle, true, true, this.rule, this.activation);
        this.getIdentityMap().remove(((InternalFactHandle)handle).getObject());
    }

    @Override
    public void retract(Object object) throws FactException {
        FactHandle handle = this.getFactHandle(object);
        if (handle == null) {
            throw new FactException("Retract error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        this.retract(handle);
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public Tuple getTuple() {
        return this.tuple;
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public KnowledgeRuntime getKnowledgeRuntime() {
        return new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)this.workingMemory);
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public void setFocus(String focus) {
        this.workingMemory.setFocus(focus);
    }

    @Override
    public Object get(Declaration declaration) {
        InternalWorkingMemoryEntryPoint wmTmp = (InternalWorkingMemoryEntryPoint)this.tuple.get(declaration).getEntryPoint();
        if (wmTmp != null) {
            Object object = declaration.getValue(wmTmp.getInternalWorkingMemory(), this.tuple.get(declaration).getObject());
            this.getIdentityMap().put(object, wmTmp.getFactHandleByIdentity(object));
            return object;
        }
        return null;
    }

    @Override
    public Declaration getDeclaration(String identifier) {
        return (Declaration)this.subrule.getOuterDeclarations().get(identifier);
    }

    @Override
    public void halt() {
        this.workingMemory.halt();
    }

    @Override
    public WorkingMemoryEntryPoint getEntryPoint(String id) {
        return this.workingMemory.getEntryPoints().get(id);
    }

    @Override
    public ExitPoint getExitPoint(String id) {
        return this.workingMemory.getExitPoints().get(id);
    }

    @Override
    public Map<String, WorkingMemoryEntryPoint> getEntryPoints() {
        return Collections.unmodifiableMap(this.workingMemory.getEntryPoints());
    }

    @Override
    public Map<String, ExitPoint> getExitPoints() {
        return Collections.unmodifiableMap(this.workingMemory.getExitPoints());
    }

    @Override
    public IdentityHashMap<Object, FactHandle> getIdentityMap() {
        return this.identityMap;
    }

    @Override
    public void setIdentityMap(IdentityHashMap<Object, FactHandle> identityMap) {
        this.identityMap = identityMap;
    }

    private FactHandle getFactHandle(Object object) {
        FactHandle handle = this.identityMap.get(object);
        if (handle == null || ((InternalFactHandle)handle).getEntryPoint() == null) {
            for (WorkingMemoryEntryPoint workingMemoryEntryPoint : this.workingMemory.getEntryPoints().values()) {
                handle = (FactHandle)workingMemoryEntryPoint.getFactHandle(object);
                if (handle == null) continue;
                this.identityMap.put(object, handle);
                break;
            }
        }
        return handle;
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        Map<Long, String> nodeInstances;
        String ruleflowGroupName;
        if (org.drools.runtime.process.ProcessContext.class.equals(contextClass) && (ruleflowGroupName = this.getActivation().getRule().getRuleFlowGroup()) != null && !(nodeInstances = ((InternalRuleFlowGroup)this.workingMemory.getAgenda().getRuleFlowGroup(ruleflowGroupName)).getNodeInstances()).isEmpty()) {
            if (nodeInstances.size() > 1) {
                throw new UnsupportedOperationException("Not supporting multiple node instances for the same ruleflow group");
            }
            Map.Entry<Long, String> entry = nodeInstances.entrySet().iterator().next();
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(entry.getKey());
            ProcessContext context = new ProcessContext();
            context.setProcessInstance(processInstance);
            String nodeInstance = entry.getValue();
            String[] nodeInstanceIds = nodeInstance.split(":");
            WorkflowProcessInstance container = (WorkflowProcessInstance)processInstance;
            int i = 0;
            while (i < nodeInstanceIds.length) {
                for (NodeInstance subNodeInstance : container.getNodeInstances()) {
                    if (subNodeInstance.getId() != new Long(nodeInstanceIds[i]).longValue()) continue;
                    if (i == nodeInstanceIds.length - 1) {
                        context.setNodeInstance(subNodeInstance);
                        break;
                    }
                    container = (NodeInstanceContainer)subNodeInstance;
                }
                ++i;
            }
            return (T)context;
        }
        return null;
    }
}

