/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.RuntimeDroolsException;
import org.drools.base.ValueType;
import org.drools.spi.ObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassObjectType
implements ObjectType,
Externalizable {
    private static final long serialVersionUID = 400L;
    protected Class<?> cls;
    protected String clsName;
    protected ValueType valueType;
    private boolean isEvent;

    public ClassObjectType() {
    }

    public ClassObjectType(Class<?> objectTypeClass) {
        this(objectTypeClass, false);
    }

    public ClassObjectType(Class<?> objectTypeClass, boolean isEvent) {
        this.cls = objectTypeClass;
        this.isEvent = isEvent;
        this.clsName = this.cls.getName();
        this.valueType = ValueType.determineValueType(objectTypeClass);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.clsName = in.readUTF();
        if (this.clsName.equals("org.drools.InitialFact") || this.clsName.equals("org.drools.base.DroolsQuery")) {
            try {
                this.setClassType(this.getClass().getClassLoader().loadClass(this.clsName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeDroolsException("Unable to resolve class '" + this.clsName + "'");
            }
        }
        this.isEvent = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.clsName);
        out.writeBoolean(this.isEvent);
    }

    public Class<?> getClassType() {
        return this.cls;
    }

    public String getClassName() {
        return this.clsName;
    }

    public void setClassType(Class<?> cls) {
        this.cls = cls;
        this.valueType = ValueType.determineValueType(cls);
    }

    @Override
    public boolean isAssignableFrom(ObjectType objectType) {
        if (!(objectType instanceof ClassObjectType)) {
            return false;
        }
        return this.cls.isAssignableFrom(((ClassObjectType)objectType).getClassType());
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isEvent() {
        return this.isEvent;
    }

    public void setEvent(boolean isEvent) {
        this.isEvent = isEvent;
    }

    public String toString() {
        return "[ClassObjectType " + (this.isEvent ? "event=" : "class=") + this.getClassType().getName() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != ClassObjectType.class) {
            return false;
        }
        return this.clsName.equals(((ClassObjectType)object).clsName);
    }

    public int hashCode() {
        return this.clsName.hashCode();
    }
}

