/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.audit.event.LogEvent;

public class RuleFlowGroupLogEvent
extends LogEvent {
    private String groupName;
    private int size;

    public RuleFlowGroupLogEvent(int type, String groupName, int size) {
        super(type);
        this.groupName = groupName;
        this.size = size;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.groupName = (String)in.readObject();
        this.size = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.groupName);
        out.writeInt(this.size);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        String msg = null;
        switch (this.getType()) {
            case 12: {
                msg = "BEFORE RULEFLOW GROUP ACTIVATED";
                break;
            }
            case 13: {
                msg = "AFTER RULEFLOW GROUP ACTIVATED";
                break;
            }
            case 14: {
                msg = "BEFORE RULEFLOW GROUP DEACTIVATED";
                break;
            }
            case 15: {
                msg = "AFTER RULEFLOW GROUP DEACTIVATED";
            }
        }
        return String.valueOf(msg) + " group:" + this.groupName + "[size=" + this.size + "]";
    }
}

