/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.audit.event.LogEvent;

public class ObjectLogEvent
extends LogEvent {
    private long factId;
    private String objectToString;

    public ObjectLogEvent(int type, long factId, String objectToString) {
        super(type);
        this.factId = factId;
        this.objectToString = objectToString;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.factId = in.readLong();
        this.objectToString = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.factId);
        out.writeObject(this.objectToString);
    }

    public long getFactId() {
        return this.factId;
    }

    public String getObjectToString() {
        return this.objectToString;
    }

    public String toString() {
        String msg = null;
        switch (this.getType()) {
            case 1: {
                msg = "OBJECT ASSERTED";
                break;
            }
            case 2: {
                msg = "OBJECT MODIFIED";
                break;
            }
            case 3: {
                msg = "OBJECT RETRACTED";
            }
        }
        return String.valueOf(msg) + " value:" + this.objectToString + " factId: " + this.factId;
    }
}

