/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.RuntimeDroolsException;
import org.drools.agent.AgentEventListener;
import org.drools.agent.FileScanner;
import org.drools.agent.HttpClientImpl;
import org.drools.agent.IHttpClient;
import org.drools.agent.LastUpdatedPing;
import org.drools.agent.PackageChangeInfo;
import org.drools.agent.PackageProvider;
import org.drools.agent.RuleAgent;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.rule.Package;

public class URLScanner
extends PackageProvider {
    URL[] urls;
    String username;
    String password;
    boolean enableBasicAuthentication = false;
    FileScanner localCacheFileScanner;
    IHttpClient httpClient = new HttpClientImpl();
    Map lastUpdated = new HashMap();
    File localCacheDir;

    void configure(Properties config) {
        this.username = config.getProperty("username");
        this.password = config.getProperty("password");
        this.enableBasicAuthentication = Boolean.parseBoolean(config.getProperty("enableBasicAuthentication"));
        List uriList = RuleAgent.list(config.getProperty("url"));
        this.urls = new URL[uriList.size()];
        int i = 0;
        while (i < uriList.size()) {
            String url = (String)uriList.get(i);
            try {
                this.urls[i] = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("The URL " + url + " is not valid.", e);
            }
            ++i;
        }
        String localCache = config.getProperty("localCacheDir");
        if (localCache != null) {
            this.localCacheDir = new File(localCache);
            if (!this.localCacheDir.isDirectory()) {
                throw new RuntimeDroolsException("The local cache dir " + localCache + " is a file, not a directory.");
            }
            this.localCacheFileScanner = new FileScanner();
            this.localCacheFileScanner.setFiles(this.getFiles(this.urls, this.localCacheDir));
            this.localCacheFileScanner.setAgentListener(this.listener);
        }
    }

    public void setAgentListener(AgentEventListener listener) {
        super.setAgentListener(listener);
        if (this.localCacheFileScanner != null) {
            this.localCacheFileScanner.setAgentListener(listener);
        }
    }

    File[] getFiles(URL[] urls, File cacheDir) {
        File[] fs = new File[urls.length];
        int i = 0;
        while (i < urls.length) {
            File f;
            URL u = urls[i];
            fs[i] = f = URLScanner.getLocalCacheFileForURL(cacheDir, u);
            ++i;
        }
        return fs;
    }

    static File getLocalCacheFileForURL(File cacheDir, URL u) {
        File f;
        try {
            f = new File(cacheDir, String.valueOf(URLEncoder.encode(u.toExternalForm(), "UTF-8")) + ".pkg");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeDroolsException(e);
        }
        return f;
    }

    PackageChangeInfo loadPackageChanges() {
        PackageChangeInfo changes = null;
        try {
            changes = this.getChangeSet();
            return changes;
        }
        catch (IOException e) {
            this.listener.exception(e);
            if (this.localCacheFileScanner != null) {
                this.listener.warning("Falling back to local cache.");
                return this.localCacheFileScanner.loadPackageChanges();
            }
        }
        catch (ClassNotFoundException e) {
            this.listener.exception(e);
            this.listener.warning("Was unable to load a class when loading a package. Perhaps it is missing from this application.");
        }
        return null;
    }

    private PackageChangeInfo getChangeSet() throws IOException, ClassNotFoundException {
        PackageChangeInfo info = new PackageChangeInfo();
        if (this.urls == null) {
            return info;
        }
        int i = 0;
        while (i < this.urls.length) {
            URL u = this.urls[i];
            if (this.hasChanged(u, this.lastUpdated)) {
                Package p = this.readPackage(u);
                if (p == null) {
                    return null;
                }
                info.addPackage(p);
                if (this.localCacheDir != null) {
                    this.writeLocalCacheCopy(p, u, this.localCacheDir);
                }
            }
            ++i;
        }
        return info;
    }

    private void writeLocalCacheCopy(Package p, URL u, File localCacheDir) {
        File local = URLScanner.getLocalCacheFileForURL(localCacheDir, u);
        if (local.exists()) {
            local.delete();
        }
        try {
            DroolsObjectOutputStream out = new DroolsObjectOutputStream(new FileOutputStream(local));
            out.writeObject(p);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.listener.exception(e);
            this.listener.warning("Was an error with the local cache directory " + localCacheDir.getPath());
        }
    }

    private Package readPackage(URL u) throws IOException, ClassNotFoundException {
        return this.httpClient.fetchPackage(u, this.enableBasicAuthentication, this.username, this.password);
    }

    private boolean hasChanged(URL u, Map updates) throws IOException {
        LastUpdatedPing pong = this.httpClient.checkLastUpdated(u);
        if (pong.isError()) {
            this.listener.warning("Was an error contacting " + u.toExternalForm() + ". Reponse header: " + pong.responseMessage);
            throw new IOException("Was unable to reach server.");
        }
        String url = u.toExternalForm();
        if (!updates.containsKey(url)) {
            updates.put(url, new Long(pong.lastUpdated));
            return true;
        }
        Long last = (Long)updates.get(url);
        if (last < pong.lastUpdated) {
            updates.put(url, new Long(pong.lastUpdated));
            return true;
        }
        return false;
    }

    public String toString() {
        String s = "URLScanner monitoring URLs: ";
        if (this.urls != null) {
            int i = 0;
            while (i < this.urls.length) {
                URL url = this.urls[i];
                s = String.valueOf(s) + " " + url.toExternalForm();
                ++i;
            }
        }
        if (this.localCacheDir != null) {
            s = String.valueOf(s) + " with local cache dir of " + this.localCacheDir.getPath();
        }
        return s;
    }
}

