/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.ClockType;
import org.drools.KnowledgeBase;
import org.drools.RuleBaseConfiguration;
import org.drools.command.CommandService;
import org.drools.core.util.ConfFileUtils;
import org.drools.core.util.StringUtils;
import org.drools.process.instance.ProcessInstanceManagerFactory;
import org.drools.process.instance.WorkItemManagerFactory;
import org.drools.process.instance.event.SignalManagerFactory;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.runtime.conf.MultiValueKnowledgeSessionOption;
import org.drools.runtime.conf.SingleValueKnowledgeSessionOption;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.util.ChainedProperties;
import org.drools.util.ClassLoaderUtil;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionConfiguration
implements KnowledgeSessionConfiguration,
Externalizable {
    private static final long serialVersionUID = 500L;
    private ChainedProperties chainedProperties;
    private volatile boolean immutable;
    private boolean keepReference;
    private ClockType clockType;
    private Map<String, WorkItemHandler> workItemHandlers;
    private ProcessInstanceManagerFactory processInstanceManagerFactory;
    private SignalManagerFactory processSignalManagerFactory;
    private WorkItemManagerFactory workItemManagerFactory;
    private CommandService commandService;
    private transient ClassLoader classLoader;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.chainedProperties);
        out.writeBoolean(this.immutable);
        out.writeBoolean(this.keepReference);
        out.writeObject((Object)this.clockType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainedProperties = (ChainedProperties)in.readObject();
        this.immutable = in.readBoolean();
        this.keepReference = in.readBoolean();
        this.clockType = (ClockType)((Object)in.readObject());
    }

    public SessionConfiguration(Properties properties) {
        this.init(null, properties);
    }

    public SessionConfiguration() {
        this.init(null, null);
    }

    public SessionConfiguration(ClassLoader classLoader) {
        this.init(classLoader, null);
    }

    private void init(ClassLoader classLoader, Properties properties) {
        this.classLoader = ClassLoaderUtil.getClassLoader((ClassLoader)classLoader, this.getClass(), (boolean)false);
        this.immutable = false;
        this.chainedProperties = new ChainedProperties("session.conf", this.classLoader);
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setKeepReference(Boolean.valueOf(this.chainedProperties.getProperty("drools.keepReference", "true")));
        this.setClockType(ClockType.resolveClockType(this.chainedProperties.getProperty("drools.clockType", "realtime")));
    }

    public void addProperties(Properties properties) {
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return;
        }
        if (name.equals("drools.keepReference")) {
            this.setKeepReference(StringUtils.isEmpty(value) ? true : Boolean.parseBoolean(value));
        } else if (name.equals("drools.clockType")) {
            this.setClockType(ClockType.resolveClockType(StringUtils.isEmpty(value) ? "realtime" : value));
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return null;
        }
        if (name.equals("drools.keepReference")) {
            return Boolean.toString(this.keepReference);
        }
        if (name.equals("drools.clockType")) {
            return this.clockType.toExternalForm();
        }
        return null;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public void setKeepReference(boolean keepReference) {
        this.checkCanChange();
        this.keepReference = keepReference;
    }

    public boolean isKeepReference() {
        return this.keepReference;
    }

    public ClockType getClockType() {
        return this.clockType;
    }

    public void setClockType(ClockType clockType) {
        this.checkCanChange();
        this.clockType = clockType;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers() {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers();
        }
        return this.workItemHandlers;
    }

    private void initWorkItemHandlers() {
        String[] locations;
        this.workItemHandlers = new HashMap<String, WorkItemHandler>();
        String[] stringArray = locations = this.chainedProperties.getProperty("drools.workItemHandlers", "").split("\\s");
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String factoryLocation = stringArray[n2];
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (!factoryLocation.equals("")) {
                this.loadWorkItemHandlers(factoryLocation);
            }
            ++n2;
        }
    }

    private void loadWorkItemHandlers(String location) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, RuleBaseConfiguration.class));
        Map workItemHandlers = (Map)MVEL.eval((String)content, new HashMap());
        this.workItemHandlers.putAll(workItemHandlers);
    }

    public ProcessInstanceManagerFactory getProcessInstanceManagerFactory() {
        if (this.processInstanceManagerFactory == null) {
            this.initProcessInstanceManagerFactory();
        }
        return this.processInstanceManagerFactory;
    }

    private void initProcessInstanceManagerFactory() {
        String className = this.chainedProperties.getProperty("drools.processInstanceManagerFactory", "org.drools.process.instance.impl.DefaultProcessInstanceManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = SessionConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.processInstanceManagerFactory = (ProcessInstanceManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate process instance manager factory '" + className + "'");
            }
        } else {
            throw new IllegalArgumentException("Process instance manager factory '" + className + "' not found");
        }
    }

    public SignalManagerFactory getSignalManagerFactory() {
        if (this.processSignalManagerFactory == null) {
            this.initSignalManagerFactory();
        }
        return this.processSignalManagerFactory;
    }

    private void initSignalManagerFactory() {
        String className = this.chainedProperties.getProperty("drools.processSignalManagerFactory", "org.drools.process.instance.event.DefaultSignalManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = SessionConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.processSignalManagerFactory = (SignalManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate signal manager factory '" + className + "'");
            }
        } else {
            throw new IllegalArgumentException("Signal manager factory '" + className + "' not found");
        }
    }

    public WorkItemManagerFactory getWorkItemManagerFactory() {
        if (this.workItemManagerFactory == null) {
            this.initWorkItemManagerFactory();
        }
        return this.workItemManagerFactory;
    }

    private void initWorkItemManagerFactory() {
        String className = this.chainedProperties.getProperty("drools.workItemManagerFactory", "org.drools.process.instance.impl.DefaultWorkItemManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = SessionConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.workItemManagerFactory = (WorkItemManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate work item manager factory '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Work item manager factory '" + className + "' not found");
        }
    }

    public CommandService getCommandService(KnowledgeBase kbase, Environment environment) {
        if (this.commandService == null) {
            this.initCommandService(kbase, environment);
        }
        return this.commandService;
    }

    private void initCommandService(KnowledgeBase kbase, Environment environment) {
        String className = this.chainedProperties.getProperty("drools.commandService", null);
        if (className == null) {
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = SessionConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.commandService = (CommandService)clazz.getConstructor(KnowledgeBase.class, KnowledgeSessionConfiguration.class, Environment.class).newInstance(kbase, this, environment);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate command service '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Command service '" + className + "' not found");
        }
    }

    public <T extends SingleValueKnowledgeSessionOption> T getOption(Class<T> option) {
        if (ClockTypeOption.class.equals(option)) {
            return (T)ClockTypeOption.get((String)this.getClockType().toExternalForm());
        }
        return null;
    }

    public <T extends MultiValueKnowledgeSessionOption> T getOption(Class<T> option, String key) {
        return null;
    }

    public <T extends KnowledgeSessionOption> void setOption(T option) {
        if (option instanceof ClockTypeOption) {
            this.setClockType(ClockType.resolveClockType(((ClockTypeOption)option).getClockType()));
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

