/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.node;

import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalWorkingMemory;
import org.drools.definition.process.Connection;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.process.instance.ProcessInstance;
import org.drools.rule.Declaration;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.drools.spi.Activation;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.node.StateNode;
import org.drools.workflow.instance.NodeInstanceContainer;
import org.drools.workflow.instance.WorkflowProcessInstance;
import org.drools.workflow.instance.node.CompositeContextNodeInstance;

public class StateNodeInstance
extends CompositeContextNodeInstance
implements EventListener,
AgendaEventListener {
    private static final long serialVersionUID = 4L;

    protected StateNode getStateNode() {
        return (StateNode)this.getNode();
    }

    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        StateNode stateNode = this.getStateNode();
        Connection selected = null;
        int priority = Integer.MAX_VALUE;
        for (Connection connection : stateNode.getOutgoingConnections("DROOLS_DEFAULT")) {
            Constraint constraint = stateNode.getConstraint(connection);
            if (constraint == null || constraint.getPriority() >= priority) continue;
            String rule = "RuleFlowStateNode-" + this.getProcessInstance().getProcessId() + "-" + this.getStateNode().getUniqueId() + "-" + connection.getTo().getId() + "-" + connection.getToType();
            boolean isActive = ((InternalAgenda)this.getProcessInstance().getAgenda()).isRuleActiveInRuleFlowGroup("DROOLS_SYSTEM", rule, this.getProcessInstance().getId());
            if (!isActive) continue;
            selected = connection;
            priority = constraint.getPriority();
        }
        if (selected != null) {
            ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
            this.triggerConnection(selected);
        } else {
            this.addTriggerListener();
            this.addActivationListener();
        }
    }

    protected boolean isLinkedIncomingNodeRequired() {
        return false;
    }

    public void signalEvent(String type, Object event) {
        if ("signal".equals(type)) {
            if (event instanceof String) {
                for (Connection connection : this.getStateNode().getOutgoingConnections("DROOLS_DEFAULT")) {
                    boolean selected = false;
                    Constraint constraint = this.getStateNode().getConstraint(connection);
                    if (constraint == null) {
                        if (((String)event).equals(connection.getTo().getName())) {
                            selected = true;
                        }
                    } else if (((String)event).equals(constraint.getName())) {
                        selected = true;
                    }
                    if (!selected) continue;
                    this.triggerEvent("onExit");
                    this.removeEventListeners();
                    ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                    this.triggerConnection(connection);
                    return;
                }
            }
        } else {
            super.signalEvent(type, event);
        }
    }

    private void addTriggerListener() {
        this.getProcessInstance().addEventListener("signal", this, false);
    }

    private void addActivationListener() {
        this.getProcessInstance().getWorkingMemory().addEventListener(this);
    }

    public void addEventListeners() {
        super.addEventListeners();
        this.addTriggerListener();
        this.addActivationListener();
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("signal", this, false);
        this.getProcessInstance().getWorkingMemory().removeEventListener(this);
    }

    public String[] getEventTypes() {
        return new String[]{"signal"};
    }

    private boolean checkProcessInstance(Activation activation) {
        Map declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) || !((value = declaration.getValue((InternalWorkingMemory)this.getProcessInstance().getWorkingMemory(), activation.getTuple().get(declaration).getObject())) instanceof ProcessInstance)) continue;
            return ((ProcessInstance)value).getId() == this.getProcessInstance().getId();
        }
        return true;
    }

    public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
        String constraintNameStart;
        String ruleName;
        String ruleFlowGroup = event.getActivation().getRule().getRuleFlowGroup();
        if ("DROOLS_SYSTEM".equals(ruleFlowGroup) && (ruleName = event.getActivation().getRule().getName()).startsWith(constraintNameStart = "RuleFlowStateNode-" + this.getProcessInstance().getProcessId() + "-" + this.getNode().getId())) {
            Connection selected = null;
            int priority = Integer.MAX_VALUE;
            for (Connection connection : this.getNode().getOutgoingConnections("DROOLS_DEFAULT")) {
                String constraintName;
                Constraint constraint = this.getStateNode().getConstraint(connection);
                if (constraint == null || constraint.getPriority() >= priority || !(constraintName = constraintNameStart + "-" + connection.getTo().getId() + "-" + connection.getToType()).equals(ruleName) || !this.checkProcessInstance(event.getActivation())) continue;
                selected = connection;
                priority = constraint.getPriority();
            }
            if (selected != null) {
                WorkflowProcessInstance workflowProcessInstance = this.getProcessInstance();
                synchronized (workflowProcessInstance) {
                    this.removeEventListeners();
                    ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                    this.triggerConnection(selected);
                }
            }
        }
    }

    public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
    }

    public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
    }
}

