/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.core.node;

import java.util.HashMap;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.impl.ConnectionRef;
import org.drools.workflow.core.node.CompositeContextNode;
import org.drools.workflow.core.node.Constrainable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateNode
extends CompositeContextNode
implements Constrainable {
    private static final long serialVersionUID = 4L;
    private Map<ConnectionRef, Constraint> constraints = new HashMap<ConnectionRef, Constraint>();

    public void setConstraints(Map<ConnectionRef, Constraint> constraints) {
        this.constraints = constraints;
    }

    public void setConstraint(Connection connection, Constraint constraint) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (!this.getDefaultOutgoingConnections().contains(connection)) {
            throw new IllegalArgumentException("connection is unknown:" + connection);
        }
        this.addConstraint(new ConnectionRef(connection.getTo().getId(), connection.getToType()), constraint);
    }

    @Override
    public void addConstraint(ConnectionRef connectionRef, Constraint constraint) {
        if (connectionRef == null) {
            throw new IllegalArgumentException("A state node only accepts constraints linked to a connection");
        }
        this.constraints.put(connectionRef, constraint);
    }

    public Constraint getConstraint(String name) {
        return this.constraints.get(name);
    }

    public Map<ConnectionRef, Constraint> getConstraints() {
        return this.constraints;
    }

    public Constraint getConstraint(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        ConnectionRef ref = new ConnectionRef(connection.getTo().getId(), connection.getToType());
        return this.constraints.get(ref);
    }
}

