/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.spi.PropagationContext;

public class ExistsNode
extends BetaNode {
    private static final long serialVersionUID = 400L;
    static int notAssertObject = 0;
    static int notAssertTuple = 0;

    public ExistsNode() {
    }

    public ExistsNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, Behavior[] behaviors, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, joinNodeBinder, behaviors);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        for (RightTuple rightTuple = memory.getRightTupleMemory().getFirst(leftTuple); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            if (!this.constraints.isAllowedCachedLeft(memory.getContext(), rightTuple.getFactHandle())) continue;
            leftTuple.setBlocker(rightTuple);
            rightTuple.setBlocked(leftTuple);
            break;
        }
        this.constraints.resetTuple(memory.getContext());
        if (leftTuple.getBlocker() != null) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
        } else if (this.tupleMemoryEnabled) {
            memory.getLeftTupleMemory().add(leftTuple);
        }
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple rightTuple = new RightTuple(factHandle, this);
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!this.behavior.assertRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory)) {
            rightTuple.unlinkFromRightParent();
            return;
        }
        memory.getRightTupleMemory().add(rightTuple);
        if (!this.tupleMemoryEnabled) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, factHandle);
        LeftTuple leftTuple = memory.getLeftTupleMemory().getFirst(rightTuple);
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)leftTuple.getNext();
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.setBlocked(leftTuple);
                if (this.tupleMemoryEnabled) {
                    memory.getLeftTupleMemory().remove(leftTuple);
                }
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
            leftTuple = temp;
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple rootBlocker = (RightTuple)rightTuple.getNext();
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        this.behavior.retractRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory);
        memory.getRightTupleMemory().remove(rightTuple);
        if (rightTuple.getBlocked() == null) {
            return;
        }
        LeftTuple leftTuple = rightTuple.getBlocked();
        while (leftTuple != null) {
            LeftTuple temp = leftTuple.getBlockedNext();
            leftTuple.setBlocker(null);
            leftTuple.setBlockedPrevious(null);
            leftTuple.setBlockedNext(null);
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            for (RightTuple newBlocker = rootBlocker; newBlocker != null; newBlocker = (RightTuple)newBlocker.getNext()) {
                if (!this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) continue;
                leftTuple.setBlocker(newBlocker);
                newBlocker.setBlocked(leftTuple);
                break;
            }
            if (leftTuple.getBlocker() == null) {
                memory.getLeftTupleMemory().add(leftTuple);
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
            leftTuple = temp;
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple blocker = leftTuple.getBlocker();
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (blocker != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            blocker.removeBlocked(leftTuple);
        } else {
            memory.getLeftTupleMemory().remove(leftTuple);
        }
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
    }

    public String toString() {
        ObjectSource source = this.rightInput;
        while (source.getClass() != ObjectTypeNode.class) {
            source = source.source;
        }
        return "[ExistsNode - " + ((ObjectTypeNode)source).getObjectType() + "]";
    }

    public short getType() {
        return 2;
    }
}

