/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.drools.FactHandle;
import org.drools.common.ActivationGroupNode;
import org.drools.common.ActivationNode;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalFactHandle;
import org.drools.common.LogicalDependency;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.AgendaGroup;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.drools.util.LinkedList;
import org.drools.util.Queue;
import org.drools.util.Queueable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgendaItem
implements Activation,
Queueable,
Externalizable {
    private static final long serialVersionUID = 400L;
    private Tuple tuple;
    private Rule rule;
    private int salience;
    private int sequenence;
    private GroupElement subrule;
    private PropagationContext context;
    private long activationNumber;
    private Queue queue;
    private int index;
    private LinkedList justified;
    private boolean activated;
    private InternalAgendaGroup agendaGroup;
    private ActivationGroupNode activationGroupNode;
    private ActivationNode activationNode;

    public AgendaItem() {
    }

    public AgendaItem(long activationNumber, Tuple tuple, int salience, PropagationContext context, Rule rule, GroupElement subrule) {
        this.tuple = tuple;
        this.context = context;
        this.rule = rule;
        this.salience = salience;
        this.subrule = subrule;
        this.activationNumber = activationNumber;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tuple = (Tuple)in.readObject();
        this.rule = (Rule)in.readObject();
        this.salience = in.readInt();
        this.sequenence = in.readInt();
        this.subrule = (GroupElement)in.readObject();
        this.context = (PropagationContext)in.readObject();
        this.activationNumber = in.readLong();
        this.queue = (Queue)in.readObject();
        this.index = in.readInt();
        this.justified = (LinkedList)in.readObject();
        this.activated = in.readBoolean();
        this.agendaGroup = (InternalAgendaGroup)in.readObject();
        this.activationGroupNode = (ActivationGroupNode)in.readObject();
        this.activationNode = (ActivationNode)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tuple);
        out.writeObject(this.rule);
        out.writeInt(this.salience);
        out.writeInt(this.sequenence);
        out.writeObject(this.subrule);
        out.writeObject(this.context);
        out.writeLong(this.activationNumber);
        out.writeObject(this.queue);
        out.writeInt(this.index);
        out.writeObject(this.justified);
        out.writeBoolean(this.activated);
        out.writeObject(this.agendaGroup);
        out.writeObject(this.activationGroupNode);
        out.writeObject(this.activationNode);
    }

    @Override
    public PropagationContext getPropagationContext() {
        return this.context;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public Tuple getTuple() {
        return this.tuple;
    }

    @Override
    public int getSalience() {
        return this.salience;
    }

    public int getSequenence() {
        return this.sequenence;
    }

    public void setSequenence(int sequenence) {
        this.sequenence = sequenence;
    }

    @Override
    public long getActivationNumber() {
        return this.activationNumber;
    }

    @Override
    public void addLogicalDependency(LogicalDependency node) {
        if (this.justified == null) {
            this.justified = new LinkedList();
        }
        this.justified.add(node);
    }

    @Override
    public LinkedList getLogicalDependencies() {
        return this.justified;
    }

    @Override
    public void setLogicalDependencies(LinkedList justified) {
        this.justified = justified;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public String toString() {
        return "[Activation rule=" + this.rule.getName() + ", tuple=" + this.tuple + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof AgendaItem)) {
            return false;
        }
        AgendaItem otherItem = (AgendaItem)object;
        return this.rule.equals(otherItem.getRule()) && this.tuple.equals(otherItem.getTuple());
    }

    public int hashCode() {
        return this.tuple.hashCode();
    }

    @Override
    public void enqueued(int index) {
        this.index = index;
    }

    @Override
    public void dequeue() {
        if (this.agendaGroup != null) {
            this.agendaGroup.remove(this);
        }
        this.activated = false;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void remove() {
        this.dequeue();
    }

    @Override
    public ActivationGroupNode getActivationGroupNode() {
        return this.activationGroupNode;
    }

    @Override
    public void setActivationGroupNode(ActivationGroupNode activationNode) {
        this.activationGroupNode = activationNode;
    }

    @Override
    public AgendaGroup getAgendaGroup() {
        return this.agendaGroup;
    }

    public void setAgendaGroup(InternalAgendaGroup agendaGroup) {
        this.agendaGroup = agendaGroup;
    }

    @Override
    public ActivationNode getActivationNode() {
        return this.activationNode;
    }

    @Override
    public void setActivationNode(ActivationNode activationNode) {
        this.activationNode = activationNode;
    }

    @Override
    public GroupElement getSubRule() {
        return this.subrule;
    }

    public Collection<FactHandle> getFactHandles() {
        InternalFactHandle[] factHandles = this.tuple.getFactHandles();
        ArrayList<InternalFactHandle> list = new ArrayList<InternalFactHandle>(factHandles.length);
        for (InternalFactHandle factHandle : factHandles) {
            list.add(factHandle);
        }
        return Collections.unmodifiableCollection(list);
    }
}

