/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.rule;

import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.impl.ExecutionResultImpl;
import org.drools.runtime.rule.AgendaFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FireAllRulesCommand
implements GenericCommand<Integer> {
    private int max = -1;
    private AgendaFilter agendaFilter = null;
    private String outIdentifier;

    public FireAllRulesCommand() {
    }

    public FireAllRulesCommand(String outIdentifer) {
        this.outIdentifier = outIdentifer;
    }

    public FireAllRulesCommand(int max) {
        this.max = max;
    }

    public FireAllRulesCommand(AgendaFilter agendaFilter) {
        this.agendaFilter = agendaFilter;
    }

    public FireAllRulesCommand(String outIdentifier, int max, AgendaFilter agendaFilter) {
        this.outIdentifier = outIdentifier;
        this.max = max;
        this.agendaFilter = agendaFilter;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public Integer execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        int fired = this.max != -1 ? ksession.fireAllRules(this.max) : (this.agendaFilter != null ? ((StatefulKnowledgeSessionImpl)ksession).session.fireAllRules(new StatefulKnowledgeSessionImpl.AgendaFilterWrapper(this.agendaFilter)) : ksession.fireAllRules());
        if (this.outIdentifier != null) {
            ((ExecutionResultImpl)((KnowledgeCommandContext)context).getExecutionResults()).getResults().put(this.outIdentifier, fired);
        }
        return fired;
    }

    public String toString() {
        if (this.max > 0) {
            return "session.fireAllRules( " + this.max + " );";
        }
        if (this.agendaFilter != null) {
            return "session.fireAllRules( " + this.agendaFilter + " );";
        }
        return "session.fireAllRules();";
    }
}

