/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.impl;

import java.util.List;
import org.drools.WorkingMemory;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.base.SequentialKnowledgeHelper;
import org.drools.common.InternalRuleBase;
import org.drools.process.instance.context.exception.ExceptionScopeInstance;
import org.drools.runtime.process.NodeInstance;
import org.drools.spi.Action;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ProcessContext;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.ExtendedNodeImpl;
import org.drools.workflow.instance.impl.NodeInstanceImpl;

public abstract class ExtendedNodeInstanceImpl
extends NodeInstanceImpl {
    private static final long serialVersionUID = 4L;

    public ExtendedNodeImpl getExtendedNode() {
        return (ExtendedNodeImpl)this.getNode();
    }

    public void internalTrigger(NodeInstance from, String type) {
        this.triggerEvent("onEntry");
    }

    public void triggerCompleted(boolean remove) {
        this.triggerCompleted("DROOLS_DEFAULT", remove);
    }

    protected void triggerCompleted(String type, boolean remove) {
        this.triggerEvent("onExit");
        super.triggerCompleted(type, remove);
    }

    protected void triggerEvent(String type) {
        ExtendedNodeImpl extendedNode = this.getExtendedNode();
        if (extendedNode == null) {
            return;
        }
        List<DroolsAction> actions = extendedNode.getActions(type);
        if (actions != null) {
            KnowledgeHelper knowledgeHelper = this.createKnowledgeHelper();
            for (DroolsAction droolsAction : actions) {
                this.executeAction(droolsAction, knowledgeHelper);
            }
        }
    }

    protected KnowledgeHelper createKnowledgeHelper() {
        KnowledgeHelper knowledgeHelper = null;
        WorkingMemory workingMemory = this.getProcessInstance().getWorkingMemory();
        knowledgeHelper = ((InternalRuleBase)workingMemory.getRuleBase()).getConfiguration().isSequential() ? new SequentialKnowledgeHelper(workingMemory) : new DefaultKnowledgeHelper(workingMemory);
        return knowledgeHelper;
    }

    protected void executeAction(DroolsAction droolsAction, KnowledgeHelper knowledgeHelper) {
        Action action = (Action)droolsAction.getMetaData("Action");
        ProcessContext context = new ProcessContext();
        context.setNodeInstance(this);
        try {
            action.execute(knowledgeHelper, this.getProcessInstance().getWorkingMemory(), context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String exceptionName = exception.getClass().getName();
            ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", exceptionName);
            if (exceptionScopeInstance == null) {
                exception.printStackTrace();
                throw new IllegalArgumentException("Could not find exception handler for " + exceptionName + " while executing node " + this.getNodeId());
            }
            exceptionScopeInstance.handleException(exceptionName, exception);
        }
    }
}

