/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.core.node;

import java.util.ArrayList;
import java.util.List;
import org.drools.definition.process.Connection;
import org.drools.process.core.event.EventFilter;
import org.drools.process.core.event.EventTransformer;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.workflow.core.impl.ExtendedNodeImpl;
import org.drools.workflow.core.node.EventNodeInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventNode
extends ExtendedNodeImpl
implements EventNodeInterface {
    private static final long serialVersionUID = 4L;
    private List<EventFilter> filters = new ArrayList<EventFilter>();
    private EventTransformer transformer;
    private String variableName;
    private String scope;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void addEventFilter(EventFilter eventFilter) {
        this.filters.add(eventFilter);
    }

    public void removeEventFilter(EventFilter eventFilter) {
        this.filters.remove(eventFilter);
    }

    public List<EventFilter> getEventFilters() {
        return this.filters;
    }

    public void setEventFilters(List<EventFilter> filters) {
        this.filters = filters;
    }

    public String getType() {
        for (EventFilter filter : this.filters) {
            if (!(filter instanceof EventTypeFilter)) continue;
            return ((EventTypeFilter)filter).getType();
        }
        return null;
    }

    @Override
    public boolean acceptsEvent(String type, Object event) {
        for (EventFilter filter : this.filters) {
            if (filter.acceptsEvent(type, event)) continue;
            return false;
        }
        return true;
    }

    public void setEventTransformer(EventTransformer transformer) {
        this.transformer = transformer;
    }

    public EventTransformer getEventTransformer() {
        return this.transformer;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default incoming connection type!");
        }
        if (this.getFrom() != null) {
            throw new IllegalArgumentException("This type of node cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default outgoing connection type!");
        }
        if (this.getTo() != null) {
            throw new IllegalArgumentException("This type of node cannot have more than one outgoing connection!");
        }
    }
}

