/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.base.ClassObjectType;
import org.drools.rule.Behavior;
import org.drools.rule.Declaration;
import org.drools.rule.MutableTypeConstraint;
import org.drools.rule.PatternSource;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.AcceptsClassObjectType;
import org.drools.spi.Constraint;
import org.drools.spi.ObjectType;
import org.drools.spi.PatternExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pattern
implements RuleConditionElement,
AcceptsClassObjectType,
Externalizable {
    private static final long serialVersionUID = 400L;
    private ObjectType objectType;
    private List constraints = Collections.EMPTY_LIST;
    private Declaration declaration;
    private Map declarations;
    private int index;
    private PatternSource source;
    private List<Behavior> behaviors;
    private int offset;

    public Pattern() {
        this(0, null);
    }

    public Pattern(int index, ObjectType objectType) {
        this(index, index, objectType, null);
    }

    public Pattern(int index, ObjectType objectType, String identifier) {
        this(index, index, objectType, identifier);
    }

    public Pattern(int index, int offset, ObjectType objectType, String identifier) {
        this(index, offset, objectType, identifier, false);
    }

    public Pattern(int index, int offset, ObjectType objectType, String identifier, boolean isInternalFact) {
        this.index = index;
        this.offset = offset;
        this.objectType = objectType;
        if (identifier != null && !identifier.equals("")) {
            this.declaration = new Declaration(identifier, new PatternExtractor(objectType), this, isInternalFact);
            this.declarations = new HashMap(2);
            this.declarations.put(this.declaration.getIdentifier(), this.declaration);
        } else {
            this.declaration = null;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.objectType = (ObjectType)in.readObject();
        this.constraints = (List)in.readObject();
        this.declaration = (Declaration)in.readObject();
        this.declarations = (Map)in.readObject();
        this.behaviors = (List)in.readObject();
        this.index = in.readInt();
        this.source = (PatternSource)in.readObject();
        this.offset = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.objectType);
        out.writeObject(this.constraints);
        out.writeObject(this.declaration);
        out.writeObject(this.declarations);
        out.writeObject(this.behaviors);
        out.writeInt(this.index);
        out.writeObject(this.source);
        out.writeInt(this.offset);
    }

    @Override
    public void setClassObjectType(ClassObjectType objectType) {
        this.objectType = objectType;
    }

    public Declaration[] getRequiredDeclarations() {
        HashSet<Declaration> decl = new HashSet<Declaration>();
        HashSet<String> locals = new HashSet<String>();
        for (Object constr : this.constraints) {
            if (constr instanceof Constraint) {
                for (Declaration d : ((Constraint)constr).getRequiredDeclarations()) {
                    if (locals.contains(d.getIdentifier())) continue;
                    decl.add(d);
                }
                continue;
            }
            locals.add(((Declaration)constr).getIdentifier());
        }
        return decl.toArray(new Declaration[decl.size()]);
    }

    @Override
    public Object clone() {
        String identifier = this.declaration != null ? this.declaration.getIdentifier() : null;
        Pattern clone = new Pattern(this.index, this.offset, this.objectType, identifier, this.declaration != null ? this.declaration.isInternalFact() : false);
        if (this.getSource() != null) {
            clone.setSource((PatternSource)this.getSource().clone());
        }
        for (Object constr : this.constraints) {
            if (constr instanceof Declaration) {
                Declaration decl = (Declaration)constr;
                clone.addDeclaration(decl.getIdentifier()).setReadAccessor(decl.getExtractor());
                continue;
            }
            Constraint constraint = (Constraint)((Constraint)constr).clone();
            Declaration[] oldDecl = ((Constraint)constr).getRequiredDeclarations();
            Declaration[] newDecl = constraint.getRequiredDeclarations();
            for (int i = 0; i < newDecl.length; ++i) {
                if (newDecl[i].getPattern() != this) continue;
                newDecl[i].setPattern(clone);
                constraint.replaceDeclaration(oldDecl[i], newDecl[i]);
            }
            clone.addConstraint(constraint);
        }
        if (this.behaviors != null) {
            for (Behavior behavior : this.behaviors) {
                clone.addBehavior(behavior);
            }
        }
        return clone;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public PatternSource getSource() {
        return this.source;
    }

    public void setSource(PatternSource source) {
        this.source = source;
    }

    public List getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList(1);
        }
        if (constraint.getType().equals((Object)Constraint.ConstraintType.UNKNOWN)) {
            this.setConstraintType((MutableTypeConstraint)constraint);
        }
        this.constraints.add(constraint);
    }

    public Declaration addDeclaration(String identifier) {
        Declaration declaration;
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList(1);
        }
        Declaration declaration2 = declaration = this.declarations != null ? (Declaration)this.declarations.get(identifier) : null;
        if (declaration == null) {
            declaration = new Declaration(identifier, this);
            this.constraints.add(declaration);
            if (this.declarations == null) {
                this.declarations = new HashMap(2);
            }
            this.declarations.put(declaration.getIdentifier(), declaration);
        }
        return declaration;
    }

    public boolean isBound() {
        return this.declaration != null;
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Map getInnerDeclarations() {
        return this.declarations != null ? this.declarations : Collections.EMPTY_MAP;
    }

    public Map getOuterDeclarations() {
        return this.declarations != null ? this.declarations : Collections.EMPTY_MAP;
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return this.declarations != null ? (Declaration)this.declarations.get(identifier) : null;
    }

    public String toString() {
        return "Pattern type='" + (this.objectType == null ? "null" : this.objectType.toString()) + "', index='" + this.index + "', offset='" + this.getOffset() + "', identifer='" + (this.declaration == null ? "" : this.declaration.toString()) + "'";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + ((Object)this.constraints).hashCode();
        result = 31 * result + (this.declaration == null ? 0 : this.declaration.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
        result = 31 * result + (this.behaviors == null ? 0 : ((Object)this.behaviors).hashCode());
        result = 31 * result + this.offset;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Pattern other = (Pattern)object;
        if (!((Object)this.constraints).equals(other.constraints)) {
            return false;
        }
        if (this.behaviors != other.behaviors || this.behaviors != null && !((Object)this.behaviors).equals(other.behaviors)) {
            return false;
        }
        if (this.declaration == null ? other.declaration != null : !this.declaration.equals(other.declaration)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (!this.objectType.equals(other.objectType)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return this.source == null ? other.source == null : this.source.equals(other.source);
    }

    public List getNestedElements() {
        return this.source != null ? Collections.singletonList(this.source) : Collections.EMPTY_LIST;
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }

    private void setConstraintType(MutableTypeConstraint constraint) {
        Declaration[] declarations = constraint.getRequiredDeclarations();
        boolean isAlphaConstraint = true;
        for (int i = 0; isAlphaConstraint && i < declarations.length; ++i) {
            if (declarations[i].isGlobal() || declarations[i].getPattern() == this) continue;
            isAlphaConstraint = false;
        }
        Constraint.ConstraintType type = isAlphaConstraint ? Constraint.ConstraintType.ALPHA : Constraint.ConstraintType.BETA;
        constraint.setType(type);
    }

    public List<Behavior> getBehaviors() {
        if (this.behaviors == null) {
            return Collections.emptyList();
        }
        return this.behaviors;
    }

    public void setBehaviors(List<Behavior> behaviors) {
        this.behaviors = behaviors;
    }

    public void addBehavior(Behavior behavior) {
        if (this.behaviors == null) {
            this.behaviors = new ArrayList<Behavior>();
        }
        this.behaviors.add(behavior);
    }
}

