/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.Restriction;

public class LiteralRestriction
implements Restriction,
AcceptsReadAccessor,
Externalizable {
    private static final long serialVersionUID = 400L;
    private FieldValue field;
    private Evaluator evaluator;
    private InternalReadAccessor readAccessor;
    private static final Declaration[] requiredDeclarations = new Declaration[0];

    public LiteralRestriction() {
        this(null, null, null);
    }

    public LiteralRestriction(FieldValue field, Evaluator evaluator, InternalReadAccessor fieldExtractor) {
        this.field = field;
        this.evaluator = evaluator;
        this.readAccessor = fieldExtractor;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.field = (FieldValue)in.readObject();
        this.evaluator = (Evaluator)in.readObject();
        this.readAccessor = (InternalReadAccessor)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.field);
        out.writeObject(this.evaluator);
        out.writeObject(this.readAccessor);
    }

    public void setReadAccessor(InternalReadAccessor readAccessor) {
        this.readAccessor = readAccessor;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public FieldValue getField() {
        return this.field;
    }

    public boolean isAllowed(InternalReadAccessor readAccessor, InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        return this.evaluator.evaluate(workingMemory, this.readAccessor, handle.getObject(), this.field);
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        return this.evaluator.evaluate(((LiteralContextEntry)context).workingMemory, ((LiteralContextEntry)context).getFieldExtractor(), handle.getObject(), this.field);
    }

    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        return this.evaluator.evaluate(((LiteralContextEntry)context).workingMemory, ((LiteralContextEntry)context).getFieldExtractor(), ((LiteralContextEntry)context).getObject(), this.field);
    }

    public Declaration[] getRequiredDeclarations() {
        return requiredDeclarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
    }

    public boolean isTemporal() {
        return this.evaluator.isTemporal();
    }

    public String toString() {
        return "[LiteralRestriction evaluator=" + this.evaluator + " value=" + this.field + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.evaluator.hashCode();
        result = 31 * result + (this.field.getValue() != null ? this.field.getValue().hashCode() : 0);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != LiteralRestriction.class) {
            return false;
        }
        LiteralRestriction other = (LiteralRestriction)object;
        return this.field.equals(other.field) && this.evaluator.equals(other.evaluator);
    }

    public ContextEntry createContextEntry() {
        return new LiteralContextEntry(this.readAccessor);
    }

    public Object clone() {
        return new LiteralRestriction(this.field, this.evaluator, this.readAccessor);
    }

    private static class LiteralContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 2621864784428098347L;
        public InternalReadAccessor extractor;
        public Object object;
        public ContextEntry next;
        public InternalWorkingMemory workingMemory;

        public LiteralContextEntry() {
        }

        public LiteralContextEntry(InternalReadAccessor extractor) {
            this.extractor = extractor;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.extractor = (InternalReadAccessor)in.readObject();
            this.object = in.readObject();
            this.next = (ContextEntry)in.readObject();
            this.workingMemory = (InternalWorkingMemory)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.extractor);
            out.writeObject(this.object);
            out.writeObject(this.next);
            out.writeObject(this.workingMemory);
        }

        public InternalReadAccessor getFieldExtractor() {
            return this.extractor;
        }

        public Object getObject() {
            return this.object;
        }

        public ContextEntry getNext() {
            return this.next;
        }

        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.workingMemory = workingMemory;
        }

        public void resetTuple() {
        }

        public void resetFactHandle() {
            this.object = null;
        }
    }
}

