/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.base.DroolsQuery;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.Iterator;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.spi.PropagationContext;

public class JoinNode
extends BetaNode {
    private static final long serialVersionUID = 400L;

    public JoinNode() {
    }

    public JoinNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints binder, Behavior[] behaviors, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, binder, behaviors);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        boolean useLeftMemory = true;
        if (this.tupleMemoryEnabled) {
            memory.getLeftTupleMemory().add(leftTuple);
        } else {
            Object object = ((InternalFactHandle)context.getFactHandle()).getObject();
            if (object instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
                useLeftMemory = false;
            } else if (memory.getLeftTupleMemory() != null) {
                memory.getLeftTupleMemory().add(leftTuple);
            }
        }
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        for (RightTuple rightTuple = memory.getRightTupleMemory().getFirst(leftTuple, (InternalFactHandle)context.getFactHandle()); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            InternalFactHandle handle = rightTuple.getFactHandle();
            if (!this.constraints.isAllowedCachedLeft(memory.getContext(), handle)) continue;
            this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, useLeftMemory);
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        RightTuple rightTuple = this.createRightTuple(factHandle, this);
        if (!this.behavior.assertRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory)) {
            rightTuple.unlinkFromRightParent();
            return;
        }
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, factHandle);
        int i = 0;
        for (LeftTuple leftTuple = memory.getLeftTupleMemory().getFirst(rightTuple); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getNext()) {
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, true);
            }
            ++i;
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        this.behavior.retractRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory);
        memory.getRightTupleMemory().remove(rightTuple);
        if (rightTuple.firstChild != null) {
            this.sink.propagateRetractRightTuple(rightTuple, context, workingMemory);
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getLeftTupleMemory().remove(leftTuple);
        if (leftTuple.firstChild != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getRightTupleMemory().remove(rightTuple);
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() != null && memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        LeftTuple childLeftTuple = rightTuple.firstChild;
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        LeftTuple leftTuple = leftMemory.getFirst(rightTuple);
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        if (childLeftTuple != null && leftMemory.isIndexed() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
            this.sink.propagateRetractRightTuple(rightTuple, context, workingMemory);
            childLeftTuple = null;
        }
        if (leftTuple != null) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                        this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, true);
                    }
                    leftTuple = (LeftTuple)leftTuple.getNext();
                }
            } else {
                while (leftTuple != null) {
                    if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                        if (childLeftTuple == null || childLeftTuple.getLeftParent() != leftTuple) {
                            this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, childLeftTuple, context, workingMemory, true);
                        } else {
                            LeftTuple temp = childLeftTuple;
                            childLeftTuple = this.sink.propagateModifyChildLeftTuple(childLeftTuple, leftTuple, context, workingMemory, true);
                            temp.reAddLeft();
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        childLeftTuple = this.sink.propagateRetractChildLeftTuple(childLeftTuple, leftTuple, context, workingMemory);
                    }
                    leftTuple = (LeftTuple)leftTuple.getNext();
                }
            }
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getLeftTupleMemory().remove(leftTuple);
        memory.getLeftTupleMemory().add(leftTuple);
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        LeftTuple childLeftTuple = leftTuple.firstChild;
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        RightTuple rightTuple = rightMemory.getFirst(leftTuple, (InternalFactHandle)context.getFactHandle());
        if (childLeftTuple != null && rightMemory.isIndexed() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            childLeftTuple = null;
        }
        if (rightTuple != null) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (this.constraints.isAllowedCachedLeft(memory.getContext(), handle)) {
                        this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, true);
                    }
                    rightTuple = (RightTuple)rightTuple.getNext();
                }
            } else {
                while (rightTuple != null) {
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (this.constraints.isAllowedCachedLeft(memory.getContext(), handle)) {
                        if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                            this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, childLeftTuple, null, context, workingMemory, true);
                        } else {
                            LeftTuple temp = childLeftTuple;
                            childLeftTuple = this.sink.propagateModifyChildLeftTuple(childLeftTuple, rightTuple, context, workingMemory, true);
                            temp.reAddRight();
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                        childLeftTuple = this.sink.propagateRetractChildLeftTuple(childLeftTuple, rightTuple, context, workingMemory);
                    }
                    rightTuple = (RightTuple)rightTuple.getNext();
                }
            }
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            for (RightTuple rightTuple = memory.getRightTupleMemory().getFirst(leftTuple, (InternalFactHandle)context.getFactHandle()); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
                if (!this.constraints.isAllowedCachedLeft(memory.getContext(), rightTuple.getFactHandle())) continue;
                sink.assertLeftTuple(new LeftTuple(leftTuple, rightTuple, null, null, sink, true), context, workingMemory);
            }
            this.constraints.resetTuple(memory.getContext());
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    public short getType() {
        return 0;
    }

    public String toString() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.source;
        }
        return "[JoinNode(" + this.getId() + ") - " + ((ObjectTypeNode)source).getObjectType() + "]";
    }
}

