/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.concurrent.atomic.AtomicReference;
import org.drools.common.InternalFactHandle;
import org.drools.core.util.Entry;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleSink;

public class ConcurrentRightTuple
extends RightTuple {
    private RightTupleList memory;
    private AtomicReference<Entry> previous;
    private AtomicReference<Entry> next;

    public ConcurrentRightTuple() {
    }

    public ConcurrentRightTuple(InternalFactHandle handle, RightTupleSink sink) {
        this.handle = handle;
        this.sink = sink;
        this.previous = new AtomicReference();
        this.next = new AtomicReference();
        RightTuple currentFirst = handle.getFirstRightTuple();
        if (currentFirst != null) {
            currentFirst.setHandlePrevious(this);
            this.setHandleNext(currentFirst);
        }
        handle.setFirstRightTuple(this);
    }

    public RightTupleList getMemory() {
        return this.memory;
    }

    public void setMemory(RightTupleList memory) {
        this.memory = memory;
    }

    public Entry getPrevious() {
        return this.previous.get();
    }

    public void setPrevious(Entry previous) {
        this.previous.set(previous);
    }

    public Entry getNext() {
        return this.next.get();
    }

    public void setNext(Entry next) {
        this.next.set(next);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return this.handle.toString() + "\n";
    }

    public boolean equals(ConcurrentRightTuple other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.hashCode() != other.hashCode()) {
            return false;
        }
        return this.handle == other.handle;
    }

    public boolean equals(Object object) {
        return this.equals((ConcurrentRightTuple)object);
    }
}

