/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.RightTuple;

public class LeftTupleList
implements LeftTupleMemory,
Entry {
    public static final long serialVersionUID = 400L;
    public Entry next;
    public LeftTuple first;
    public LeftTuple last;
    private int hashCode;
    private AbstractHashTable.Index index;
    private TupleHashTableIterator iterator;
    private int size;

    public LeftTupleList() {
        this.hashCode = 0;
        this.index = null;
    }

    public LeftTupleList(AbstractHashTable.Index index, int hashCode) {
        this.index = index;
        this.hashCode = hashCode;
    }

    public LeftTuple getFirst(RightTuple rightTuple) {
        return this.first;
    }

    public LeftTuple getFirst(LeftTuple leftTuple) {
        return this.first;
    }

    public LeftTuple getLast(RightTuple lastTuple) {
        return this.first;
    }

    public void add(LeftTuple leftTuple) {
        if (this.last != null) {
            this.last.setNext(leftTuple);
            leftTuple.setPrevious(this.last);
            this.last = leftTuple;
        } else {
            this.first = leftTuple;
            this.last = leftTuple;
        }
        ++this.size;
    }

    public void remove(LeftTuple leftTuple) {
        LeftTuple previous = (LeftTuple)leftTuple.getPrevious();
        LeftTuple next = (LeftTuple)leftTuple.getNext();
        if (previous != null && next != null) {
            previous.setNext(next);
            next.setPrevious(previous);
        } else if (next != null) {
            this.first = next;
            next.setPrevious(null);
        } else if (previous != null) {
            this.last = previous;
            previous.setNext(null);
        } else {
            this.last = null;
            this.first = null;
        }
        leftTuple.setPrevious(null);
        leftTuple.setNext(null);
        --this.size;
    }

    public boolean contains(LeftTuple leftTuple) {
        return this.get(leftTuple) != null;
    }

    public Object get(LeftTuple leftTtuple) {
        for (LeftTuple current = this.first; current != null; current = (LeftTuple)current.getNext()) {
            if (!leftTtuple.equals(current)) continue;
            return current;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public LeftTuple[] toArray() {
        LeftTuple[] tuples = new LeftTuple[this.size];
        LeftTuple current = this.first;
        for (int i = 0; i < this.size; ++i) {
            tuples[i] = current;
            current = (LeftTuple)current.getNext();
        }
        return tuples;
    }

    public Entry getBucket(Object object) {
        return this.first;
    }

    public Iterator iterator() {
        if (this.iterator == null) {
            this.iterator = new TupleHashTableIterator();
        }
        this.iterator.reset(this.first);
        return this.iterator;
    }

    public boolean isIndexed() {
        return false;
    }

    public boolean matches(Object object, int objectHashCode) {
        return this.hashCode == objectHashCode && this.index.equal(object, this.first);
    }

    public boolean matches(LeftTuple tuple, int tupleHashCode) {
        return this.hashCode == tupleHashCode && this.index.equal(this.first, tuple);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        LeftTupleList other = (LeftTupleList)object;
        return this.hashCode == other.hashCode && this.index == other.index;
    }

    public Entry getNext() {
        return this.next;
    }

    public void setNext(Entry next) {
        this.next = next;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator it = this.iterator();
        LeftTuple leftTuple = (LeftTuple)it.next();
        while (leftTuple != null) {
            builder.append(leftTuple + "\n");
            leftTuple = (LeftTuple)it.next();
        }
        return builder.toString();
    }

    public static class TupleHashTableIterator
    implements Iterator {
        private LeftTuple current;

        public void reset(LeftTuple first) {
            this.current = first;
        }

        public Object next() {
            if (this.current != null) {
                LeftTuple returnValue = this.current;
                this.current = (LeftTuple)this.current.getNext();
                return returnValue;
            }
            return null;
        }

        public void remove() {
        }
    }
}

