/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.RuleBaseConfiguration;
import org.drools.base.evaluators.Operator;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.LeftTupleIndexHashTable;
import org.drools.core.util.LeftTupleList;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.RightTupleIndexHashTable;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.RightTupleMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Constraint;

public class DefaultBetaConstraints
implements BetaConstraints {
    private static final long serialVersionUID = 400L;
    private LinkedList constraints;
    private int indexed;

    public DefaultBetaConstraints() {
    }

    public DefaultBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf) {
        this(constraints, conf, false);
    }

    public DefaultBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf, boolean disableIndexing) {
        this.indexed = -1;
        this.constraints = new LinkedList();
        int depth = conf.getCompositeKeyDepth();
        int length = constraints.length;
        for (int i = 0; i < length; ++i) {
            if (!disableIndexing && conf.isIndexLeftBetaMemory() && conf.isIndexRightBetaMemory() && this.isIndexable(constraints[i]) && this.indexed < depth - 1) {
                if (depth >= 1 && this.indexed == -1) {
                    this.constraints.insertAfter(null, new LinkedListEntry(constraints[i]));
                    ++this.indexed;
                    continue;
                }
                this.constraints.insertAfter(this.findNode(this.indexed++), new LinkedListEntry(constraints[i]));
                continue;
            }
            this.constraints.add(new LinkedListEntry(constraints[i]));
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraints = (LinkedList)in.readObject();
        this.indexed = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraints);
        out.writeInt(this.indexed);
    }

    public ContextEntry[] createContext() {
        ContextEntry[] contexts = new ContextEntry[this.constraints.size()];
        int i = 0;
        for (LinkedListEntry entry = (LinkedListEntry)this.constraints.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
            BetaNodeFieldConstraint constraint = (BetaNodeFieldConstraint)entry.getObject();
            contexts[i++] = constraint.createContextEntry();
        }
        return contexts;
    }

    private LinkedListEntry findNode(int pos) {
        LinkedListEntry current = (LinkedListEntry)this.constraints.getFirst();
        for (int i = 0; i < pos; ++i) {
            current = (LinkedListEntry)current.getNext();
        }
        return current;
    }

    private boolean isIndexable(BetaNodeFieldConstraint constraint) {
        if (constraint instanceof VariableConstraint) {
            VariableConstraint variableConstraint = (VariableConstraint)constraint;
            return variableConstraint.getEvaluator().getOperator() == Operator.EQUAL;
        }
        return false;
    }

    public void updateFromTuple(ContextEntry[] context, InternalWorkingMemory workingMemory, LeftTuple tuple) {
        for (int i = 0; i < context.length; ++i) {
            context[i].updateFromTuple(workingMemory, tuple);
        }
    }

    public void updateFromFactHandle(ContextEntry[] context, InternalWorkingMemory workingMemory, InternalFactHandle handle) {
        for (int i = 0; i < context.length; ++i) {
            context[i].updateFromFactHandle(workingMemory, handle);
        }
    }

    public void resetTuple(ContextEntry[] context) {
        for (int i = 0; i < context.length; ++i) {
            context[i].resetTuple();
        }
    }

    public void resetFactHandle(ContextEntry[] context) {
        for (int i = 0; i < context.length; ++i) {
            context[i].resetFactHandle();
        }
    }

    public boolean isAllowedCachedLeft(ContextEntry[] context, InternalFactHandle handle) {
        LinkedListEntry entry = this.findNode(this.indexed + 1);
        int i = 1;
        while (entry != null) {
            if (!((BetaNodeFieldConstraint)entry.getObject()).isAllowedCachedLeft(context[this.indexed + i], handle)) {
                return false;
            }
            entry = (LinkedListEntry)entry.getNext();
            ++i;
        }
        return true;
    }

    public boolean isAllowedCachedRight(ContextEntry[] context, LeftTuple tuple) {
        LinkedListEntry entry = this.findNode(this.indexed + 1);
        int i = 1;
        while (entry != null) {
            if (!((BetaNodeFieldConstraint)entry.getObject()).isAllowedCachedRight(tuple, context[this.indexed + i])) {
                return false;
            }
            entry = (LinkedListEntry)entry.getNext();
            ++i;
        }
        return true;
    }

    public boolean isIndexed() {
        return this.indexed >= 0;
    }

    public int getIndexCount() {
        return this.indexed + 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public BetaMemory createBetaMemory(RuleBaseConfiguration config) {
        BetaMemory memory;
        if (this.indexed >= 0) {
            LinkedListEntry entry = (LinkedListEntry)this.constraints.getFirst();
            ArrayList<AbstractHashTable.FieldIndex> list = new ArrayList<AbstractHashTable.FieldIndex>();
            for (int pos = 0; pos <= this.indexed; ++pos) {
                Constraint constraint = (Constraint)entry.getObject();
                VariableConstraint variableConstraint = (VariableConstraint)constraint;
                AbstractHashTable.FieldIndex index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
                list.add(index);
                entry = (LinkedListEntry)entry.getNext();
            }
            AbstractHashTable.FieldIndex[] indexes = list.toArray(new AbstractHashTable.FieldIndex[list.size()]);
            LeftTupleMemory tupleMemory = config.isIndexLeftBetaMemory() ? new LeftTupleIndexHashTable(indexes) : new LeftTupleList();
            RightTupleMemory factHandleMemory = config.isIndexRightBetaMemory() ? new RightTupleIndexHashTable(indexes) : new RightTupleList();
            memory = new BetaMemory(config.isSequential() ? null : tupleMemory, factHandleMemory, this.createContext());
        } else {
            memory = new BetaMemory(config.isSequential() ? null : new LeftTupleList(), new RightTupleList(), this.createContext());
        }
        return memory;
    }

    public int hashCode() {
        return this.constraints.hashCode();
    }

    public LinkedList getConstraints() {
        return this.constraints;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DefaultBetaConstraints)) {
            return false;
        }
        DefaultBetaConstraints other = (DefaultBetaConstraints)object;
        if (this.constraints == other.constraints) {
            return true;
        }
        if (this.constraints.size() != other.constraints.size()) {
            return false;
        }
        return this.constraints.equals(other.constraints);
    }
}

