/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassObjectType;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.spi.AcceptsClassObjectType;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;

public class GlobalExtractor
implements Externalizable,
AcceptsClassObjectType,
InternalReadAccessor {
    private static final long serialVersionUID = 400L;
    private String identifier;
    private ValueType valueType;
    private ObjectType objectType;

    public GlobalExtractor() {
    }

    public GlobalExtractor(String identifier, ObjectType objectType) {
        this.identifier = identifier;
        this.objectType = objectType;
        this.valueType = objectType.getValueType();
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return workingMemory.getGlobal(this.identifier);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.identifier);
        out.writeObject(this.objectType);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.identifier = in.readUTF();
        this.objectType = (ObjectType)in.readObject();
        this.valueType = this.objectType.getValueType();
    }

    public void setClassObjectType(ClassObjectType objectType) {
        this.objectType = objectType;
    }

    public Class getExtractToClass() {
        if (this.objectType instanceof ClassObjectType) {
            return ((ClassObjectType)this.objectType).getClassType();
        }
        return this.valueType.getClassType();
    }

    public String getExtractToClassName() {
        if (this.objectType instanceof ClassObjectType) {
            return ((ClassObjectType)this.objectType).getClassName();
        }
        return this.valueType.getClassType().getName();
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.valueType.isBoolean()) {
            return (Boolean)workingMemory.getGlobal(this.identifier);
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a boolean.");
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.valueType.isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).byteValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a byte.");
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.valueType.isChar()) {
            return ((Character)workingMemory.getGlobal(this.identifier)).charValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a char.");
    }

    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.valueType.isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).doubleValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a double.");
    }

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.valueType.isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).floatValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a float.");
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.valueType.isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).intValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into an int.");
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.valueType.isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).longValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a long.");
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.valueType.isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).shortValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a short.");
    }

    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        Object value = this.getValue(workingMemory, object);
        return value != null ? value.hashCode() : 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalExtractor other = (GlobalExtractor)obj;
        if (this.objectType == null ? other.objectType != null : !this.objectType.equals(other.objectType)) {
            return false;
        }
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }

    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        Object value = this.getValue(workingMemory, object);
        return value == null;
    }

    public boolean isGlobal() {
        return true;
    }

    public boolean isSelfReference() {
        return false;
    }

    public boolean getBooleanValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public byte getByteValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public char getCharValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public double getDoubleValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public float getFloatValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public int getHashCode(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public int getIndex() {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public int getIntValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public long getLongValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public short getShortValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public Object getValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }

    public boolean isNullValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from a global without a working memory reference");
    }
}

