/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.RuleConditionElement;

public class GroupElement
extends ConditionalElement
implements Externalizable {
    private static final long serialVersionUID = 400L;
    public static final Type AND = Type.AND;
    public static final Type OR = Type.OR;
    public static final Type NOT = Type.NOT;
    public static final Type EXISTS = Type.EXISTS;
    private Type type = null;
    private List children = new ArrayList();

    public GroupElement() {
        this(Type.AND);
    }

    public GroupElement(Type type) {
        this.type = type;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = (Type)((Object)in.readObject());
        this.children = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.type);
        out.writeObject(this.children);
    }

    public void addChild(RuleConditionElement child) {
        if ((this.isNot() || this.isExists()) && this.children.size() > 0) {
            throw new RuntimeDroolsException(this.type.toString() + " can have only a single child element. Either a single Pattern or another CE.");
        }
        this.children.add(child);
    }

    public void addChild(int index, RuleConditionElement rce) {
        this.children.add(index, rce);
    }

    public List getChildren() {
        return this.children;
    }

    public Map getInnerDeclarations() {
        return this.type.getInnerDeclarations(this.children);
    }

    public Map getOuterDeclarations() {
        return this.type.getOuterDeclarations(this.children);
    }

    public Declaration resolveDeclaration(String identifier) {
        return (Declaration)this.type.getInnerDeclarations(this.children).get(identifier);
    }

    public void pack() {
        Object child;
        Object[] clone = this.children.toArray();
        for (int i = 0; i < clone.length; ++i) {
            if (!(clone[i] instanceof GroupElement)) continue;
            GroupElement childGroup = (GroupElement)clone[i];
            childGroup.pack(this);
        }
        if ((this.isAnd() || this.isOr()) && this.children.size() == 1 && (child = this.getChildren().get(0)) instanceof GroupElement) {
            GroupElement group = (GroupElement)child;
            this.type = group.getType();
            this.children.clear();
            this.children.addAll(group.getChildren());
        }
    }

    public void pack(GroupElement parent) {
        if (this.children.size() == 0) {
            parent.children.remove(this);
            return;
        }
        if (this.isAnd() || this.isOr() || this.isExists()) {
            if (parent.getType() == this.getType()) {
                int index = parent.getChildren().indexOf(this);
                parent.getChildren().remove(this);
                for (Object child : this.children) {
                    parent.getChildren().add(index++, child);
                    if (!(child instanceof GroupElement)) continue;
                    int previousSize = parent.getChildren().size();
                    ((GroupElement)child).pack(parent);
                    index += parent.getChildren().size() - previousSize;
                }
            } else if (!this.isExists() && this.children.size() == 1) {
                int index = parent.getChildren().indexOf(this);
                parent.getChildren().remove(this);
                Object child = this.children.get(0);
                parent.getChildren().add(index, child);
                if (child instanceof GroupElement) {
                    ((GroupElement)child).pack(parent);
                }
            } else {
                this.pack();
            }
        } else {
            this.pack();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GroupElement)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GroupElement e2 = (GroupElement)object;
        if (!this.type.equals((Object)e2.type)) {
            return false;
        }
        List e1Children = this.getChildren();
        List e2Children = e2.getChildren();
        if (e1Children.size() != e2Children.size()) {
            return false;
        }
        for (int i = 0; i < e1Children.size(); ++i) {
            Object e2Object1;
            Object e1Object1 = e1Children.get(i);
            if (e1Object1.equals(e2Object1 = e2Children.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.type.hashCode() + ((Object)this.children).hashCode();
    }

    public Object clone() {
        GroupElement cloned = null;
        try {
            cloned = (GroupElement)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not clone '" + this.getClass().getName() + "'");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not clone '" + this.getClass().getName() + "'");
        }
        cloned.setType(this.getType());
        for (RuleConditionElement re : this.children) {
            if (re instanceof GroupElement) {
                re = (RuleConditionElement)((GroupElement)re).clone();
            }
            cloned.addChild(re);
        }
        return cloned;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isAnd() {
        return AND.equals((Object)this.type);
    }

    public boolean isOr() {
        return OR.equals((Object)this.type);
    }

    public boolean isNot() {
        return NOT.equals((Object)this.type);
    }

    public boolean isExists() {
        return EXISTS.equals((Object)this.type);
    }

    public String toString() {
        return this.type.toString() + this.children.toString();
    }

    public List getNestedElements() {
        return this.children;
    }

    public boolean isPatternScopeDelimiter() {
        return this.type.isPatternScopeDelimiter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        AND(false),
        OR(false),
        NOT(true),
        EXISTS(true);

        private final boolean scopeDelimiter;

        private Type(boolean scopeDelimiter) {
            this.scopeDelimiter = scopeDelimiter;
        }

        public Map getInnerDeclarations(List children) {
            Map declarations = null;
            if (children.isEmpty()) {
                declarations = Collections.EMPTY_MAP;
            } else if (children.size() == 1) {
                RuleConditionElement re = (RuleConditionElement)children.get(0);
                declarations = re.getOuterDeclarations();
            } else {
                declarations = new HashMap();
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    declarations.putAll(((RuleConditionElement)it.next()).getOuterDeclarations());
                }
            }
            return declarations;
        }

        public Map getOuterDeclarations(List children) {
            Map declarations = null;
            if (this.scopeDelimiter || children.isEmpty()) {
                declarations = Collections.EMPTY_MAP;
            } else if (children.size() == 1) {
                RuleConditionElement re = (RuleConditionElement)children.get(0);
                declarations = re.getOuterDeclarations();
            } else {
                declarations = new HashMap();
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    declarations.putAll(((RuleConditionElement)it.next()).getOuterDeclarations());
                }
            }
            return declarations;
        }

        public boolean isPatternScopeDelimiter() {
            return this.scopeDelimiter;
        }
    }
}

