/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.WorkingMemoryAction;
import org.drools.marshalling.MarshallerReaderContext;
import org.drools.marshalling.MarshallerWriteContext;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;

public class PropagationQueuingNode
extends ObjectSource
implements ObjectSinkNode,
NodeMemory {
    private static final long serialVersionUID = -615639068150958767L;
    private static final int PROPAGATION_SLICE_LIMIT = 1000;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    private PropagateAction action;

    public PropagationQueuingNode() {
    }

    public PropagationQueuingNode(int id, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.action = new PropagateAction(this);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.previousObjectSinkNode = (ObjectSinkNode)in.readObject();
        this.nextObjectSinkNode = (ObjectSinkNode)in.readObject();
        this.action = (PropagateAction)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.previousObjectSinkNode);
        out.writeObject(this.nextObjectSinkNode);
        out.writeObject(this.action);
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        if (!memory.isEmpty()) {
            throw new RuntimeDroolsException("Error updating sink. Not safe to update sink as the PropagatingQueueingNode memory is not for node: " + this.toString());
        }
        this.source.updateSink(sink, context, workingMemory);
    }

    public void attach() {
        this.source.addObjectSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
        }
        this.source.remove(context, builder, this, workingMemories);
    }

    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        memory.addAction(new AssertAction(factHandle, context));
        if (memory.isQueued().compareAndSet(false, true)) {
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    public boolean isObjectMemoryEnabled() {
        return true;
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        memory.addAction(new RetractAction(handle, context));
        if (memory.isQueued().compareAndSet(false, true)) {
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    public void propagateActions(InternalWorkingMemory workingMemory) {
        PropagationQueueingNodeMemory memory = (PropagationQueueingNodeMemory)workingMemory.getNodeMemory(this);
        memory.isQueued().set(false);
        Action next = memory.getNext();
        for (int counter = 0; next != null && counter < 1000; ++counter) {
            next.execute(this.sink, workingMemory);
            next = memory.getNext();
        }
        if (memory.hasNext()) {
            memory.isQueued().set(true);
            workingMemory.queueWorkingMemoryAction(this.action);
        }
    }

    public void setObjectMemoryEnabled(boolean objectMemoryOn) {
        throw new UnsupportedOperationException("PropagationQueueingNode must have its node memory enabled.");
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new PropagationQueueingNodeMemory();
    }

    public static class PropagateAction
    implements WorkingMemoryAction {
        private static final long serialVersionUID = 6765029029501617115L;
        private PropagationQueuingNode node;

        public PropagateAction() {
        }

        public PropagateAction(PropagationQueuingNode node) {
            this.node = node;
        }

        public PropagateAction(MarshallerReaderContext context) throws IOException {
            this.node = (PropagationQueuingNode)context.sinks.get(context.readInt());
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.write(this.node.getId());
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.node = (PropagationQueuingNode)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.node);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.node.propagateActions(workingMemory);
        }
    }

    private static class RetractAction
    extends Action {
        private static final long serialVersionUID = -84784886430845209L;

        public RetractAction() {
        }

        public RetractAction(InternalFactHandle handle, PropagationContext context) {
            super(handle, context);
        }

        public void execute(ObjectSinkPropagator sink, InternalWorkingMemory workingMemory) {
            for (RightTuple rightTuple = this.handle.getRightTuple(); rightTuple != null; rightTuple = rightTuple.getHandleNext()) {
                rightTuple.getRightTupleSink().retractRightTuple(rightTuple, this.context, workingMemory);
            }
            this.handle.setRightTuple(null);
            for (LeftTuple leftTuple = this.handle.getLeftTuple(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
                leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, this.context, workingMemory);
            }
            this.handle.setLeftTuple(null);
        }
    }

    private static class AssertAction
    extends Action {
        private static final long serialVersionUID = -8478488926430845209L;

        public AssertAction(InternalFactHandle handle, PropagationContext context) {
            super(handle, context);
        }

        public void execute(ObjectSinkPropagator sink, InternalWorkingMemory workingMemory) {
            sink.propagateAssertObject(this.handle, this.context, workingMemory);
        }
    }

    private static abstract class Action
    implements Externalizable {
        protected InternalFactHandle handle;
        protected PropagationContext context;

        public Action() {
        }

        public Action(InternalFactHandle handle, PropagationContext context) {
            this.handle = handle;
            this.context = context;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.handle);
            out.writeObject(this.context);
        }

        public abstract void execute(ObjectSinkPropagator var1, InternalWorkingMemory var2);
    }

    public static class PropagationQueueingNodeMemory
    implements Externalizable {
        private static final long serialVersionUID = 7372028632974484023L;
        private ConcurrentLinkedQueue<Action> queue = new ConcurrentLinkedQueue();
        private AtomicBoolean isQueued = new AtomicBoolean(false);

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.queue = (ConcurrentLinkedQueue)in.readObject();
            this.isQueued = (AtomicBoolean)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.queue);
            out.writeObject(this.isQueued);
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void addAction(Action action) {
            this.queue.add(action);
        }

        public Action getNext() {
            return this.queue.poll();
        }

        public boolean hasNext() {
            return this.queue.peek() != null;
        }

        public AtomicBoolean isQueued() {
            return this.isQueued;
        }
    }
}

