/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.core.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.process.core.ParameterDefinition;
import org.drools.process.core.WorkDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkDefinitionImpl
implements WorkDefinition,
Serializable {
    private static final long serialVersionUID = 400L;
    private String name;
    private Map<String, ParameterDefinition> parameters = new HashMap<String, ParameterDefinition>();
    private Map<String, ParameterDefinition> results = new HashMap<String, ParameterDefinition>();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Set<ParameterDefinition> getParameters() {
        return new HashSet<ParameterDefinition>(this.parameters.values());
    }

    public void setParameters(Set<ParameterDefinition> parameters) {
        this.parameters.clear();
        Iterator<ParameterDefinition> iterator = parameters.iterator();
        while (iterator.hasNext()) {
            this.addParameter(iterator.next());
        }
    }

    public void addParameter(ParameterDefinition parameter) {
        this.parameters.put(parameter.getName(), parameter);
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    @Override
    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    @Override
    public ParameterDefinition getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public Set<ParameterDefinition> getResults() {
        return new HashSet<ParameterDefinition>(this.results.values());
    }

    public void setResults(Set<ParameterDefinition> results) {
        this.results.clear();
        Iterator<ParameterDefinition> it = results.iterator();
        while (it.hasNext()) {
            this.addResult(it.next());
        }
    }

    public void addResult(ParameterDefinition result) {
        this.results.put(result.getName(), result);
    }

    public void removeResult(String name) {
        this.results.remove(name);
    }

    @Override
    public String[] getResultNames() {
        return this.results.keySet().toArray(new String[this.results.size()]);
    }

    @Override
    public ParameterDefinition getResult(String name) {
        return this.results.get(name);
    }

    public String toString() {
        return this.name;
    }
}

