/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.core.datatype.impl.type;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.process.core.datatype.DataType;

public class ObjectDataType
implements DataType {
    private static final long serialVersionUID = 4L;
    private String className;

    public ObjectDataType() {
    }

    public ObjectDataType(String className) {
        this.setClassName(className);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.className);
    }

    public boolean verifyDataType(Object value) {
        if (value == null) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(this.className);
            if (clazz.isInstance(value)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find data type " + this.className);
        }
        return false;
    }

    public Object readValue(String value) {
        XStream xstream = new XStream();
        return xstream.fromXML(value);
    }

    public String writeValue(Object value) {
        XStream xstream = new XStream();
        return xstream.toXML(value);
    }

    public String getStringType() {
        return this.className == null ? "Object" : this.className;
    }
}

