/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.memory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.drools.persistence.memory.MemoryPersister;

public class MemoryXaResource
implements XAResource {
    private MemoryPersister pm;
    Map<Xid, byte[]> data = new HashMap<Xid, byte[]>();
    LinkedList<Xid> list = new LinkedList();

    public MemoryXaResource(MemoryPersister pm) {
        this.pm = pm;
    }

    public boolean isInTransaction() {
        return this.list.size() > 0;
    }

    public void start(Xid xid, int flags) throws XAException {
        byte[] bytes = this.pm.getSnapshot();
        if (this.list.isEmpty()) {
            this.pm.setLastSave(bytes);
        }
        this.list.add(xid);
        this.data.put(xid, bytes);
    }

    public void rollback(Xid xid) throws XAException {
        if (this.list.isEmpty()) {
            return;
        }
        byte[] bytes = this.data.get(xid);
        boolean remove = false;
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            Xid currentXid = (Xid)it.next();
            if (!remove && currentXid.equals(xid)) {
                remove = true;
            }
            if (!remove) continue;
            this.data.remove(currentXid);
            it.remove();
        }
        this.pm.loadSnapshot(bytes);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.list.getFirst().equals(xid) && this.list.size() > 1) {
            this.pm.setLastSave(this.data.get(this.list.get(1)));
        } else if (this.list.size() == 1) {
            this.pm.setLastSave(this.pm.getSnapshot());
        }
        this.list.remove(xid);
        this.data.remove(xid);
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }
}

