/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.RuleBaseConfiguration;
import org.drools.StatefulSession;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.concurrent.ExecutorService;
import org.drools.marshalling.ClassPlaceholderResolverStrategyAcceptor;
import org.drools.marshalling.IdentityPlaceholderResolverStrategy;
import org.drools.marshalling.InputMarshaller;
import org.drools.marshalling.Marshaller;
import org.drools.marshalling.MarshallerReaderContext;
import org.drools.marshalling.MarshallerWriteContext;
import org.drools.marshalling.OutputMarshaller;
import org.drools.marshalling.PlaceholderResolverStrategyFactory;
import org.drools.marshalling.RuleBaseNodes;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.spi.GlobalResolver;

public class DefaultMarshaller
implements Marshaller {
    GlobalResolver globalResolver;
    RuleBaseConfiguration config;
    PlaceholderResolverStrategyFactory factory;

    public DefaultMarshaller() {
        this(null);
    }

    public DefaultMarshaller(RuleBaseConfiguration config) {
        this(config, null);
    }

    public DefaultMarshaller(RuleBaseConfiguration config, PlaceholderResolverStrategyFactory factory) {
        RuleBaseConfiguration ruleBaseConfiguration = this.config = config != null ? config : new RuleBaseConfiguration();
        if (factory == null) {
            this.factory = new PlaceholderResolverStrategyFactory();
            ClassPlaceholderResolverStrategyAcceptor acceptor = new ClassPlaceholderResolverStrategyAcceptor("*.*");
            IdentityPlaceholderResolverStrategy strategy = new IdentityPlaceholderResolverStrategy(acceptor);
            this.factory.addStrategy(strategy);
        } else {
            this.factory = factory;
        }
    }

    public ReteooStatefulSession read(InputStream stream, InternalRuleBase ruleBase, int id, ExecutorService executor) throws IOException, ClassNotFoundException {
        MarshallerReaderContext context = new MarshallerReaderContext(stream, ruleBase, RuleBaseNodes.getNodeMap(ruleBase), this.factory);
        ReteooStatefulSession session = InputMarshaller.readSession(context, id, executor);
        context.close();
        return session;
    }

    public StatefulSession read(InputStream stream, InternalRuleBase ruleBase, StatefulSession session) throws IOException, ClassNotFoundException {
        MarshallerReaderContext context = new MarshallerReaderContext(stream, ruleBase, RuleBaseNodes.getNodeMap(ruleBase), this.factory);
        session = InputMarshaller.readSession((ReteooStatefulSession)session, context);
        context.close();
        return session;
    }

    public void write(OutputStream stream, InternalRuleBase ruleBase, StatefulSession session) throws IOException {
        MarshallerWriteContext context = new MarshallerWriteContext(stream, ruleBase, (InternalWorkingMemory)((Object)session), RuleBaseNodes.getNodeMap(ruleBase), this.factory);
        OutputMarshaller.writeSession(context);
        context.close();
    }
}

