/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.io.InternalResource;
import org.drools.io.Resource;
import org.drools.io.impl.BaseResource;
import org.drools.io.impl.FileSystemResource;
import org.drools.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlResource
extends BaseResource
implements InternalResource,
Externalizable {
    private URL url;
    private long lastRead = -1L;

    public UrlResource() {
    }

    public UrlResource(URL url) {
        this.url = this.getCleanedUrl(url, url.toString());
    }

    public UrlResource(String path) {
        try {
            this.url = this.getCleanedUrl(new URL(path), path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("'" + path + "' path is malformed", e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.url);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.url = (URL)in.readObject();
    }

    public InputStream getInputStream() throws IOException {
        this.lastRead = this.getLastModified();
        URLConnection con = this.url.openConnection();
        con.setUseCaches(false);
        return con.getInputStream();
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    private URL getCleanedUrl(URL originalUrl, String originalPath) {
        try {
            return new URL(StringUtils.cleanPath(originalPath));
        }
        catch (MalformedURLException ex) {
            return originalUrl;
        }
    }

    @Override
    public URL getURL() throws IOException {
        return this.url;
    }

    @Override
    public boolean hasURL() {
        return true;
    }

    public File getFile() throws IOException {
        try {
            return new File(StringUtils.toURI(this.url.toString()).getSchemeSpecificPart());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get File for url " + this.url, e);
        }
    }

    @Override
    public long getLastModified() {
        try {
            if ("file".equals(this.url.getProtocol())) {
                File file = this.getFile();
                return file.lastModified();
            }
            URLConnection conn = this.getURL().openConnection();
            long date = conn.getLastModified();
            return date;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get LastMofified for ClasspathResource", e);
        }
    }

    @Override
    public long getLastRead() {
        return this.lastRead;
    }

    @Override
    public boolean isDirectory() {
        try {
            URL url = this.getURL();
            if ("file".equals(url.getProtocol())) {
                File file = new File(StringUtils.toURI(url.toString()).getSchemeSpecificPart());
                return file.isDirectory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        try {
            URL url = this.getURL();
            if ("file".equals(url.getProtocol())) {
                File dir = this.getFile();
                ArrayList<Resource> resources = new ArrayList<Resource>();
                for (File file : dir.listFiles()) {
                    resources.add(new FileSystemResource(file));
                }
                return resources;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj == this || obj instanceof UrlResource && this.url.equals(((UrlResource)obj).url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return "[UrlResource path='" + this.url.toString() + "']";
    }
}

