/*
 * Decompiled with CFR 0.152.
 */
package org.drools.facttemplates;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.drools.facttemplates.Fact;
import org.drools.facttemplates.FactImpl;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FieldTemplate;
import org.drools.rule.Package;

public class FactTemplateImpl
implements FactTemplate {
    private FieldTemplate[] fields;
    private Package pkg;
    private String name;

    private static int hashCode(Object[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
        }
        return result;
    }

    public FactTemplateImpl() {
    }

    public FactTemplateImpl(Package pkg, String name, FieldTemplate[] fields) {
        this.pkg = pkg;
        this.name = name;
        this.fields = fields;
        this.pkg.addFactTemplate(this);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pkg = (Package)in.readObject();
        this.name = (String)in.readObject();
        this.fields = (FieldTemplate[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.pkg);
        out.writeObject(this.name);
        out.writeObject(this.fields);
    }

    public Package getPackage() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfFields() {
        return this.fields.length;
    }

    public FieldTemplate[] getAllFieldTemplates() {
        return this.fields;
    }

    public FieldTemplate getFieldTemplate(String name) {
        for (int idx = 0; idx < this.fields.length; ++idx) {
            if (!this.fields[idx].getName().equals(name)) continue;
            return this.fields[idx];
        }
        return null;
    }

    public FieldTemplate getFieldTemplate(int index) {
        return this.fields[index];
    }

    public int getFieldTemplateIndex(String name) {
        for (int index = 0; index < this.fields.length; ++index) {
            if (!this.fields[index].getName().equals(name)) continue;
            return index;
        }
        return -1;
    }

    public Fact createFact(long id) {
        return new FactImpl(this, id);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.name + " ");
        buf.append(")");
        return buf.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + FactTemplateImpl.hashCode(this.fields);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.pkg.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FactTemplateImpl other = (FactTemplateImpl)object;
        if (!Arrays.equals(this.fields, other.fields)) {
            return false;
        }
        return this.pkg.equals(other.pkg) && this.name.equals(other.name);
    }
}

