/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.factmodel.FieldDefinition;
import org.drools.rule.FactField;
import org.drools.rule.FactType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDefinition
implements FactType {
    private String className;
    private String superClass;
    private String[] interfaces;
    private transient Class<?> definedClass;
    private Map<String, FieldDefinition> fields = new LinkedHashMap<String, FieldDefinition>();

    public ClassDefinition() {
        this(null, null, null);
    }

    public ClassDefinition(String className) {
        this(className, null, null);
    }

    public ClassDefinition(String className, String superClass) {
        this(className, superClass, null);
    }

    public ClassDefinition(String className, String[] interfaces) {
        this(className, null, interfaces);
    }

    public ClassDefinition(String className, String superClass, String[] interfaces) {
        this.setClassName(className);
        this.setSuperClass(superClass);
        this.setInterfaces(interfaces);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.superClass = (String)in.readObject();
        this.interfaces = (String[])in.readObject();
        this.fields = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.superClass);
        out.writeObject(this.interfaces);
        out.writeObject(this.fields);
    }

    public final String getClassName() {
        return this.className;
    }

    public final void setClassName(String className) {
        this.className = className;
    }

    public final Class<?> getDefinedClass() {
        return this.definedClass;
    }

    public void setDefinedClass(Class<?> definedClass) {
        this.definedClass = definedClass;
    }

    public final void addField(FieldDefinition attr) {
        this.fields.put(attr.getName(), attr);
    }

    public final Collection<FieldDefinition> getFieldsDefinitions() {
        return Collections.unmodifiableCollection(this.fields.values());
    }

    @Override
    public final FieldDefinition getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public final String[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces != null ? interfaces : new String[]{};
    }

    public final String getSuperClass() {
        return this.superClass;
    }

    public final void setSuperClass(String superClass) {
        this.superClass = superClass != null ? superClass : "java.lang.Object";
    }

    @Override
    public String getName() {
        return this.getClassName();
    }

    @Override
    public Object newInstance() throws InstantiationException, IllegalAccessException {
        return this.definedClass.newInstance();
    }

    @Override
    public Class<?> getFactClass() {
        return this.getDefinedClass();
    }

    @Override
    public List<FactField> getFields() {
        return new ArrayList<FactField>(this.fields.values());
    }

    @Override
    public Object get(Object bean, String field) {
        return this.getField(field).getFieldAccessor().getValue(bean);
    }

    @Override
    public void set(Object bean, String field, Object value) {
        this.getField(field).getFieldAccessor().setValue(bean, value);
    }

    @Override
    public Map<String, Object> getAsMap(Object bean) {
        HashMap<String, Object> m = new HashMap<String, Object>(this.fields.size());
        for (Map.Entry<String, FieldDefinition> ent : this.fields.entrySet()) {
            Object val = ent.getValue().getFieldAccessor().getValue(bean);
            m.put(ent.getKey(), val);
        }
        return m;
    }

    @Override
    public void setFromMap(Object bean, Map<String, Object> data) {
        for (Map.Entry<String, Object> ent : data.entrySet()) {
            this.set(bean, ent.getKey(), ent.getValue());
        }
    }
}

