/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.FactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.definition.rule.Rule;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.EntryPoint;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.util.ObjectHashMap;

public class PropagationContextImpl
implements PropagationContext {
    private static final long serialVersionUID = 8400185220119865618L;
    private int type;
    private org.drools.rule.Rule rule;
    private LeftTuple leftTuple;
    private InternalFactHandle factHandle;
    private long propagationNumber;
    public int activeActivations;
    public int dormantActivations;
    public ObjectHashMap retracted;
    private EntryPoint entryPoint;

    public PropagationContextImpl() {
    }

    public PropagationContextImpl(long number, int type, org.drools.rule.Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle) {
        this.type = type;
        this.rule = rule;
        this.leftTuple = leftTuple;
        this.factHandle = factHandle;
        this.propagationNumber = number;
        this.activeActivations = 0;
        this.dormantActivations = 0;
        this.entryPoint = EntryPoint.DEFAULT;
    }

    public PropagationContextImpl(long number, int type, org.drools.rule.Rule rule, LeftTuple leftTuple, InternalFactHandle factHandle, int activeActivations, int dormantActivations, EntryPoint entryPoint) {
        this.type = type;
        this.rule = rule;
        this.leftTuple = leftTuple;
        this.factHandle = factHandle;
        this.propagationNumber = number;
        this.activeActivations = activeActivations;
        this.dormantActivations = dormantActivations;
        this.entryPoint = entryPoint;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.activeActivations = in.readInt();
        this.dormantActivations = in.readInt();
        this.propagationNumber = in.readLong();
        this.rule = (org.drools.rule.Rule)in.readObject();
        this.leftTuple = (LeftTuple)in.readObject();
        this.retracted = (ObjectHashMap)in.readObject();
        this.entryPoint = (EntryPoint)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeInt(this.activeActivations);
        out.writeInt(this.dormantActivations);
        out.writeLong(this.propagationNumber);
        out.writeObject(this.rule);
        out.writeObject(this.leftTuple);
        out.writeObject(this.retracted);
        out.writeObject(this.entryPoint);
    }

    public long getPropagationNumber() {
        return this.propagationNumber;
    }

    public org.drools.rule.Rule getRuleOrigin() {
        return this.rule;
    }

    public Rule getRule() {
        return this.rule;
    }

    public LeftTuple getLeftTupleOrigin() {
        return this.leftTuple;
    }

    public InternalFactHandle getFactHandleOrigin() {
        return this.factHandle;
    }

    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    public int getType() {
        return this.type;
    }

    public int getActiveActivations() {
        return this.activeActivations;
    }

    public int getDormantActivations() {
        return this.dormantActivations;
    }

    public void addRetractedTuple(org.drools.rule.Rule rule, Activation activation) {
        if (this.retracted == null) {
            this.retracted = new ObjectHashMap();
        }
        LeftTuple tuple = (LeftTuple)activation.getTuple();
        ObjectHashMap tuples = (ObjectHashMap)this.retracted.get(rule);
        if (tuples == null) {
            tuples = new ObjectHashMap();
            this.retracted.put(rule, tuples);
        }
        tuples.put(tuple, activation);
    }

    public Activation removeRetractedTuple(org.drools.rule.Rule rule, LeftTuple tuple) {
        if (this.retracted == null) {
            return null;
        }
        ObjectHashMap tuples = (ObjectHashMap)this.retracted.get(rule);
        if (tuples != null) {
            return (Activation)tuples.remove(tuple);
        }
        return null;
    }

    public void clearRetractedTuples() {
        this.retracted = null;
    }

    public void releaseResources() {
        this.leftTuple = null;
        this.retracted = null;
        this.rule = null;
    }

    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }
}

