/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.ClockType;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.process.command.CommandService;
import org.drools.process.instance.ProcessInstanceManagerFactory;
import org.drools.process.instance.WorkItemManagerFactory;
import org.drools.process.instance.event.SignalManagerFactory;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.util.ChainedProperties;
import org.drools.util.ConfFileUtils;
import org.drools.util.StringUtils;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionConfiguration
implements KnowledgeSessionConfiguration,
Externalizable {
    private static final long serialVersionUID = 500L;
    private ChainedProperties chainedProperties;
    private volatile boolean immutable;
    private boolean keepReference;
    private ClockType clockType;
    private Map<String, WorkItemHandler> workItemHandlers;
    private ProcessInstanceManagerFactory processInstanceManagerFactory;
    private SignalManagerFactory processSignalManagerFactory;
    private WorkItemManagerFactory workItemManagerFactory;
    private CommandService commandService;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.chainedProperties);
        out.writeBoolean(this.immutable);
        out.writeBoolean(this.keepReference);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainedProperties = (ChainedProperties)in.readObject();
        this.immutable = in.readBoolean();
        this.keepReference = in.readBoolean();
    }

    public SessionConfiguration(Properties properties) {
        this.init(properties);
    }

    public SessionConfiguration() {
        this.init(null);
    }

    private void init(Properties properties) {
        this.immutable = false;
        this.chainedProperties = new ChainedProperties("session.conf");
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setKeepReference(Boolean.valueOf(this.chainedProperties.getProperty("drools.keepReference", "true")));
        this.setClockType(ClockType.resolveClockType(this.chainedProperties.getProperty("drools.clockType", "realtime")));
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return;
        }
        if (name.equals("drools.keepReference")) {
            this.setKeepReference(StringUtils.isEmpty(value) ? true : Boolean.parseBoolean(value));
        } else if (name.equals("drools.clockType")) {
            this.setClockType(ClockType.resolveClockType(StringUtils.isEmpty(value) ? "realtime" : value));
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return null;
        }
        if (name.equals("drools.keepReference")) {
            return Boolean.toString(this.keepReference);
        }
        if (name.equals("drools.clockType")) {
            return this.clockType.toExternalForm();
        }
        return null;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public void setKeepReference(boolean keepReference) {
        this.checkCanChange();
        this.keepReference = keepReference;
    }

    public boolean isKeepReference() {
        return this.keepReference;
    }

    public ClockType getClockType() {
        return this.clockType;
    }

    public void setClockType(ClockType clockType) {
        this.checkCanChange();
        this.clockType = clockType;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers() {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers();
        }
        return this.workItemHandlers;
    }

    private void initWorkItemHandlers() {
        String[] locations;
        this.workItemHandlers = new HashMap<String, WorkItemHandler>();
        for (String factoryLocation : locations = this.chainedProperties.getProperty("drools.workItemHandlers", "").split("\\s")) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadWorkItemHandlers(factoryLocation);
        }
    }

    private void loadWorkItemHandlers(String location) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, RuleBaseConfiguration.class));
        Map workItemHandlers = (Map)MVEL.eval((String)content, new HashMap());
        this.workItemHandlers.putAll(workItemHandlers);
    }

    public ProcessInstanceManagerFactory getProcessInstanceManagerFactory() {
        if (this.processInstanceManagerFactory == null) {
            this.initProcessInstanceManagerFactory();
        }
        return this.processInstanceManagerFactory;
    }

    private void initProcessInstanceManagerFactory() {
        String className = this.chainedProperties.getProperty("drools.processInstanceManagerFactory", "org.drools.process.instance.impl.DefaultProcessInstanceManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = SessionConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.processInstanceManagerFactory = (ProcessInstanceManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate process instance manager factory '" + className + "'");
            }
        } else {
            throw new IllegalArgumentException("Process instance manager factory '" + className + "' not found");
        }
    }

    public SignalManagerFactory getSignalManagerFactory() {
        if (this.processSignalManagerFactory == null) {
            this.initSignalManagerFactory();
        }
        return this.processSignalManagerFactory;
    }

    private void initSignalManagerFactory() {
        String className = this.chainedProperties.getProperty("drools.processSignalManagerFactory", "org.drools.process.instance.event.DefaultSignalManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = SessionConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.processSignalManagerFactory = (SignalManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate signal manager factory '" + className + "'");
            }
        } else {
            throw new IllegalArgumentException("Signal manager factory '" + className + "' not found");
        }
    }

    public WorkItemManagerFactory getWorkItemManagerFactory() {
        if (this.workItemManagerFactory == null) {
            this.initWorkItemManagerFactory();
        }
        return this.workItemManagerFactory;
    }

    private void initWorkItemManagerFactory() {
        String className = this.chainedProperties.getProperty("drools.workItemManagerFactory", "org.drools.process.instance.impl.DefaultWorkItemManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = SessionConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.workItemManagerFactory = (WorkItemManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate work item manager factory '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Work item manager factory '" + className + "' not found");
        }
    }

    public CommandService getCommandService(RuleBase ruleBase) {
        if (this.commandService == null) {
            this.initCommandService(ruleBase);
        }
        return this.commandService;
    }

    private void initCommandService(RuleBase ruleBase) {
        String className = this.chainedProperties.getProperty("drools.commandService", null);
        if (className == null) {
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = SessionConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.commandService = (CommandService)clazz.getConstructor(RuleBase.class, SessionConfiguration.class).newInstance(ruleBase, this);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate command service '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Command service '" + className + "' not found");
        }
    }
}

