/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.ruleflow.common.core.impl.ProcessImpl;
import org.drools.ruleflow.core.Node;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.ruleflow.core.StartNode;
import org.drools.ruleflow.core.Variable;

public class RuleFlowProcessImpl
extends ProcessImpl
implements RuleFlowProcess {
    public static final String RULEFLOW_TYPE = "RuleFlow";
    private static final long serialVersionUID = 400L;
    private Map nodes;
    private List variables;
    private long lastNodeId;
    private List imports;
    private Map globals;

    public RuleFlowProcessImpl() {
        this.setType(RULEFLOW_TYPE);
        this.nodes = new HashMap();
        this.variables = new ArrayList();
    }

    public StartNode getStart() {
        Iterator it = this.nodes.values().iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!(node instanceof StartNode)) continue;
            return (StartNode)node;
        }
        return null;
    }

    public Node[] getNodes() {
        return this.nodes.values().toArray(new Node[this.nodes.size()]);
    }

    public Node getNode(long id) {
        Long idLong = new Long(id);
        if (!this.nodes.containsKey(idLong)) {
            throw new IllegalArgumentException("Unknown node id: " + id);
        }
        return (Node)this.nodes.get(idLong);
    }

    public void removeNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        Node n = (Node)this.nodes.remove(new Long(node.getId()));
        if (n == null) {
            throw new IllegalArgumentException("Unknown node: " + node);
        }
    }

    public List getVariables() {
        return this.variables;
    }

    public void setVariables(List variables) {
        if (variables == null) {
            throw new IllegalArgumentException("Variables is null");
        }
        this.variables = variables;
    }

    public String[] getVariableNames() {
        String[] result = new String[this.variables.size()];
        if (this.variables != null) {
            for (int i = 0; i < this.variables.size(); ++i) {
                result[i] = ((Variable)this.variables.get(i)).getName();
            }
        }
        return result;
    }

    public void addNode(Node node) {
        this.validateAddNode(node);
        if (!this.nodes.containsValue(node)) {
            node.setId(++this.lastNodeId);
            this.nodes.put(new Long(node.getId()), node);
        }
    }

    private void validateAddNode(Node node) {
        if (node instanceof StartNode && this.getStart() != null) {
            throw new IllegalArgumentException("A ruleflow process cannot have more than one start node!");
        }
    }

    public List getImports() {
        return this.imports;
    }

    public void setImports(List imports) {
        this.imports = imports;
    }

    public Map getGlobals() {
        return this.globals;
    }

    public void setGlobals(Map globals) {
        this.globals = globals;
    }

    public String[] getGlobalNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.globals != null) {
            Iterator iterator = this.globals.keySet().iterator();
            while (iterator.hasNext()) {
                result.add((String)iterator.next());
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

