/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Arrays;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Accumulate;
import org.drools.rule.ContextEntry;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.drools.util.ArrayUtils;
import org.drools.util.Entry;
import org.drools.util.FactEntry;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class AccumulateNode
extends BetaNode {
    private static final long serialVersionUID = 400L;
    private final boolean unwrapRightObject;
    private final Accumulate accumulate;
    private final AlphaNodeFieldConstraint[] resultConstraints;
    private final BetaConstraints resultBinder;

    public AccumulateNode(int id, TupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultBinder, Accumulate accumulate, boolean unwrapRightObject, BuildContext context) {
        super(id, leftInput, rightInput, sourceBinder);
        this.resultBinder = resultBinder;
        this.resultConstraints = resultConstraints;
        this.accumulate = accumulate;
        this.unwrapRightObject = unwrapRightObject;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object accContext;
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        AccumulateResult accresult = new AccumulateResult();
        if (this.tupleMemoryEnabled) {
            memory.betaMemory.getTupleMemory().add(leftTuple);
            memory.betaMemory.getCreatedHandles().put(leftTuple, accresult, false);
        }
        accresult.context = accContext = this.accumulate.createContext();
        this.accumulate.init(memory.workingMemoryContext, accContext, leftTuple, workingMemory);
        Iterator it = memory.betaMemory.getFactHandleMemory().iterator(leftTuple);
        this.constraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        FactEntry entry = (FactEntry)it.next();
        while (entry != null) {
            InternalFactHandle handle = entry.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(memory.betaMemory.getContext(), handle.getObject())) {
                if (this.unwrapRightObject) {
                    ReteTuple tuple = (ReteTuple)handle.getObject();
                    handle = tuple.getLastHandle();
                    this.accumulate.accumulate(memory.workingMemoryContext, accContext, tuple, handle, workingMemory);
                } else {
                    this.accumulate.accumulate(memory.workingMemoryContext, accContext, leftTuple, handle, workingMemory);
                }
            }
            entry = (FactEntry)it.next();
        }
        this.constraints.resetTuple(memory.betaMemory.getContext());
        Object result = this.accumulate.getResult(memory.workingMemoryContext, accContext, leftTuple, workingMemory);
        if (result == null) {
            throw new RuntimeDroolsException("Accumulate must not return a null value.");
        }
        boolean isAllowed = true;
        int length = this.resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(result, workingMemory, memory.alphaContexts[i])) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            this.resultBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
            if (this.resultBinder.isAllowedCachedLeft(memory.resultsContext, result)) {
                InternalFactHandle handle;
                accresult.handle = handle = workingMemory.getFactHandleFactory().newFactHandle(result);
                this.sink.propagateAssertTuple(leftTuple, handle, context, workingMemory);
            }
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        if (memory.betaMemory.getTupleMemory().remove(leftTuple) == null) {
            return;
        }
        AccumulateResult accresult = (AccumulateResult)memory.betaMemory.getCreatedHandles().remove(leftTuple);
        if (accresult.handle != null) {
            this.sink.propagateRetractTuple(leftTuple, accresult.handle, context, workingMemory);
            workingMemory.getFactHandleFactory().destroyFactHandle(accresult.handle);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getFactHandleMemory().add(handle);
        if (!this.tupleMemoryEnabled) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.betaMemory.getContext(), workingMemory, handle);
        Entry[] tuples = memory.betaMemory.getTupleMemory().toArray();
        for (int i = 0; i < tuples.length; ++i) {
            ReteTuple tuple = (ReteTuple)tuples[i];
            if (!this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), tuple)) continue;
            if (this.accumulate.supportsReverse() || context.getType() == 0) {
                this.modifyTuple(true, tuple, handle, context, workingMemory);
                continue;
            }
            this.retractTuple(tuple, context, workingMemory);
            this.assertTuple(tuple, context, workingMemory);
        }
        this.constraints.resetFactHandle(memory.betaMemory.getContext());
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        if (!memory.betaMemory.getFactHandleMemory().remove(handle)) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.betaMemory.getContext(), workingMemory, handle);
        Entry[] tuples = memory.betaMemory.getTupleMemory().toArray();
        for (int i = 0; i < tuples.length; ++i) {
            ReteTuple tuple = (ReteTuple)tuples[i];
            if (!this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), tuple)) continue;
            if (this.accumulate.supportsReverse()) {
                this.modifyTuple(false, tuple, handle, context, workingMemory);
                continue;
            }
            this.retractTuple(tuple, context, workingMemory);
            this.assertTuple(tuple, context, workingMemory);
        }
        this.constraints.resetFactHandle(memory.betaMemory.getContext());
    }

    public void modifyTuple(boolean isAssert, ReteTuple leftTuple, InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        AccumulateResult accresult = (AccumulateResult)memory.betaMemory.getCreatedHandles().get(leftTuple);
        if (accresult.handle != null) {
            this.sink.propagateRetractTuple(leftTuple, accresult.handle, context, workingMemory);
            workingMemory.getFactHandleFactory().destroyFactHandle(accresult.handle);
            accresult.handle = null;
        }
        ReteTuple tuple = leftTuple;
        if (this.unwrapRightObject) {
            tuple = (ReteTuple)handle.getObject();
            handle = tuple.getLastHandle();
        }
        if (context.getType() == 0) {
            if (accresult.context == null) {
                Object accContext = this.accumulate.createContext();
                this.accumulate.init(memory.workingMemoryContext, accContext, leftTuple, workingMemory);
                accresult.context = accContext;
            }
            this.accumulate.accumulate(memory.workingMemoryContext, accresult.context, tuple, handle, workingMemory);
        } else if (context.getType() == 2 || context.getType() == 3 || context.getType() == 4) {
            if (isAssert) {
                this.accumulate.accumulate(memory.workingMemoryContext, accresult.context, tuple, handle, workingMemory);
            } else {
                this.accumulate.reverse(memory.workingMemoryContext, accresult.context, tuple, handle, workingMemory);
            }
        } else {
            this.accumulate.reverse(memory.workingMemoryContext, accresult.context, tuple, handle, workingMemory);
        }
        Object result = this.accumulate.getResult(memory.workingMemoryContext, accresult.context, leftTuple, workingMemory);
        if (result == null) {
            throw new RuntimeDroolsException("Accumulate must not return a null value.");
        }
        boolean isAllowed = true;
        int length = this.resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(result, workingMemory, memory.alphaContexts[i])) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            this.resultBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
            if (this.resultBinder.isAllowedCachedLeft(memory.resultsContext, result)) {
                InternalFactHandle createdHandle;
                accresult.handle = createdHandle = workingMemory.getFactHandleFactory().newFactHandle(result);
                this.sink.propagateAssertTuple(leftTuple, createdHandle, context, workingMemory);
            }
            this.resultBinder.resetTuple(memory.resultsContext);
        }
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.betaMemory.getCreatedHandles().iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            AccumulateResult accresult = (AccumulateResult)entry.getValue();
            sink.assertTuple(new ReteTuple((ReteTuple)entry.getKey(), accresult.handle), context, workingMemory);
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.accumulate.hashCode() ^ this.resultBinder.hashCode() ^ ArrayUtils.hashCode(this.resultConstraints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AccumulateNode)) {
            return false;
        }
        AccumulateNode other = (AccumulateNode)object;
        if (!(this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints))) {
            return false;
        }
        return this.accumulate.equals(other.accumulate) && this.resultBinder.equals(other.resultBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    public String toString() {
        return "[ " + this.getClass().getName() + "(" + this.id + ") ]";
    }

    public Object createMemory(RuleBaseConfiguration config) {
        AccumulateMemory memory = new AccumulateMemory();
        memory.betaMemory = this.constraints.createBetaMemory(config);
        memory.workingMemoryContext = this.accumulate.createWorkingMemoryContext();
        memory.resultsContext = this.resultBinder.createContext();
        memory.alphaContexts = new ContextEntry[this.resultConstraints.length];
        for (int i = 0; i < this.resultConstraints.length; ++i) {
            memory.alphaContexts[i] = this.resultConstraints[i].createContextEntry();
        }
        return memory;
    }

    private static class AccumulateResult {
        public InternalFactHandle handle;
        public Object context;

        private AccumulateResult() {
        }
    }

    public static class AccumulateMemory {
        private static final long serialVersionUID = 400L;
        public Object workingMemoryContext;
        public BetaMemory betaMemory;
        public ContextEntry[] resultsContext;
        public ContextEntry[] alphaContexts;
    }
}

