/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.util.Collection;
import java.util.Comparator;
import org.drools.base.BaseEvaluator;
import org.drools.base.ShadowProxy;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;
import org.drools.util.ShadowProxyUtils;

public class ObjectFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = 400L;
    private static EvaluatorFactory INSTANCE = new ObjectFactory();

    private ObjectFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ObjectFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return ObjectEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return ObjectNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return ObjectLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return ObjectLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return ObjectGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return ObjectGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.CONTAINS) {
            return ObjectContainsEvaluator.INSTANCE;
        }
        if (operator == Operator.EXCLUDES) {
            return ObjectExcludesEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_CONTAINS) {
            return ObjectExcludesEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return ObjectMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return ObjectNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for ObjectEvaluator");
    }

    protected static class ObjectComparator
    implements Comparator {
        protected ObjectComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 == null || arg1 == null) {
                if (arg0 == arg1) {
                    return 0;
                }
                throw new NullPointerException("Can't compare " + arg0 + " to " + arg1);
            }
            if (arg0 instanceof Double || arg0 instanceof Float) {
                double val0 = ((Number)arg0).doubleValue();
                double val1 = 0.0;
                if (arg1 instanceof Number) {
                    val1 = ((Number)arg1).doubleValue();
                } else if (arg1 instanceof String) {
                    val1 = Double.parseDouble((String)arg1);
                } else {
                    throw new ClassCastException("Not possible to convert " + arg1.getClass() + " into a double value to compare it to " + arg0.getClass());
                }
                return val0 > val1 ? 1 : (val0 < val1 ? -1 : 0);
            }
            if (arg0 instanceof Number) {
                long val0 = ((Number)arg0).longValue();
                long val1 = 0L;
                if (arg1 instanceof Number) {
                    val1 = ((Number)arg1).longValue();
                } else if (arg1 instanceof String) {
                    val1 = Long.parseLong((String)arg1);
                } else {
                    throw new ClassCastException("Not possible to convert " + arg1.getClass() + " into a long value to compare it to " + arg0.getClass());
                }
                return val0 > val1 ? 1 : (val0 < val1 ? -1 : 0);
            }
            if (arg0 instanceof String) {
                try {
                    double val0 = Double.parseDouble((String)arg0);
                    double val1 = 0.0;
                    if (arg1 instanceof Number) {
                        val1 = ((Number)arg1).doubleValue();
                    } else if (arg1 instanceof String) {
                        val1 = Double.parseDouble((String)arg1);
                    } else {
                        throw new ClassCastException("Not possible to convert " + arg1.getClass() + " into a double value to compare it to " + arg0.getClass());
                    }
                    return val0 > val1 ? 1 : (val0 < val1 ? -1 : 0);
                }
                catch (NumberFormatException nfe) {
                    return ((String)arg0).compareTo(arg1.toString());
                }
            }
            try {
                return ((Comparable)arg0).compareTo(arg1);
            }
            catch (ClassCastException cce) {
                throw new ClassCastException("Not possible to compare a " + arg0.getClass() + " with a " + arg1.getClass());
            }
        }
    }

    protected static class ObjectEqualsComparator {
        protected ObjectEqualsComparator() {
        }

        public boolean equals(Object arg0, Object arg1) {
            if (arg0 == null || arg1 == null) {
                return arg0 == arg1;
            }
            if (arg1 instanceof ShadowProxy) {
                return arg1.equals(arg0);
            }
            if (arg0 instanceof Number) {
                double val0 = ((Number)arg0).doubleValue();
                double val1 = 0.0;
                if (arg1 instanceof Number) {
                    val1 = ((Number)arg1).doubleValue();
                } else if (arg1 instanceof String) {
                    val1 = Double.parseDouble((String)arg1);
                } else {
                    throw new ClassCastException("Not possible to compare " + arg1.getClass() + " to " + arg0.getClass());
                }
                return val0 == val1;
            }
            if (arg0 instanceof String) {
                return arg0.equals(arg1.toString());
            }
            if (arg0 instanceof Boolean && arg1 instanceof String) {
                return ((Boolean)arg0).booleanValue() == Boolean.valueOf((String)arg1).booleanValue();
            }
            if (arg0 instanceof Character && arg1 instanceof String && ((String)arg1).length() == 1) {
                return ((Character)arg0).charValue() == ((String)arg1).charAt(0);
            }
            return arg0.equals(arg1);
        }
    }

    static class ObjectNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectNotMemberOfEvaluator();

        private ObjectNotMemberOfEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "Object not memberOf";
        }
    }

    static class ObjectMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectMemberOfEvaluator();

        private ObjectMemberOfEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "Object memberOf";
        }
    }

    static class ObjectExcludesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectExcludesEvaluator();

        private ObjectExcludesEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.EXCLUDES);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value = object2.getValue();
            Collection col = (Collection)extractor.getValue(workingMemory, object1);
            return col == null ? true : !ShadowProxyUtils.contains(col, value);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            Collection col = (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return col == null ? true : !ShadowProxyUtils.contains(col, value);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Collection col = (Collection)context.extractor.getValue(workingMemory, right);
            return col == null ? true : !ShadowProxyUtils.contains(col, value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value = extractor2.getValue(workingMemory, object2);
            Collection col = (Collection)extractor1.getValue(workingMemory, object1);
            return col == null ? true : !ShadowProxyUtils.contains(col, value);
        }

        public String toString() {
            return "Object excludes";
        }
    }

    static class ObjectContainsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectContainsEvaluator();

        private ObjectContainsEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.CONTAINS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value = object2.getValue();
            Collection col = (Collection)extractor.getValue(workingMemory, object1);
            return col == null ? false : ShadowProxyUtils.contains(col, value);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            Collection col = (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return col == null ? false : ShadowProxyUtils.contains(col, value);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Collection col = (Collection)context.extractor.getValue(workingMemory, right);
            return col == null ? false : ShadowProxyUtils.contains(col, value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value = extractor2.getValue(workingMemory, object2);
            Collection col = (Collection)extractor1.getValue(workingMemory, object1);
            return col == null ? false : ShadowProxyUtils.contains(col, value);
        }

        public String toString() {
            return "Object contains";
        }
    }

    static class ObjectGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectGreaterOrEqualEvaluator();
        private static final ObjectComparator comparator = new ObjectComparator();

        private ObjectGreaterOrEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comparator.compare(comp, object2.getValue()) >= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comparator.compare(comp, context.declaration.getExtractor().getValue(workingMemory, left)) >= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comparator.compare(comp, ((VariableRestriction.ObjectVariableContextEntry)context).left) >= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comparator.compare(comp, extractor2.getValue(workingMemory, object2)) >= 0;
        }

        public String toString() {
            return "Object >=";
        }
    }

    static class ObjectGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectGreaterEvaluator();
        private static final ObjectComparator comparator = new ObjectComparator();

        private ObjectGreaterEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comparator.compare(comp, object2.getValue()) > 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comparator.compare(comp, context.declaration.getExtractor().getValue(workingMemory, left)) > 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comparator.compare(comp, ((VariableRestriction.ObjectVariableContextEntry)context).left) > 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comparator.compare(comp, extractor2.getValue(workingMemory, object2)) > 0;
        }

        public String toString() {
            return "Object >";
        }
    }

    static class ObjectLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectLessOrEqualEvaluator();
        private static final ObjectComparator comparator = new ObjectComparator();

        private ObjectLessOrEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comparator.compare(comp, object2.getValue()) <= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comparator.compare(comp, context.declaration.getExtractor().getValue(workingMemory, left)) <= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comparator.compare(comp, ((VariableRestriction.ObjectVariableContextEntry)context).left) <= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comparator.compare(comp, extractor2.getValue(workingMemory, object2)) <= 0;
        }

        public String toString() {
            return "Object <=";
        }
    }

    static class ObjectLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectLessEvaluator();
        private static final ObjectComparator comparator = new ObjectComparator();

        private ObjectLessEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comparator.compare(comp, object2.getValue()) < 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comparator.compare(comp, context.declaration.getExtractor().getValue(workingMemory, left)) < 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comparator.compare(comp, ((VariableRestriction.ObjectVariableContextEntry)context).left) < 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comparator.compare(comp, extractor2.getValue(workingMemory, object2)) < 0;
        }

        public String toString() {
            return "Object <";
        }
    }

    static class ObjectNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectNotEqualEvaluator();
        private static final ObjectEqualsComparator comparator = new ObjectEqualsComparator();

        private ObjectNotEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value2;
            Object value1 = extractor.getValue(workingMemory, object1);
            return !comparator.equals(value1, value2 = object2.getValue());
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value1 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            Object value2 = context.declaration.getExtractor().getValue(workingMemory, left);
            return !comparator.equals(value1, value2);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value2;
            Object value1 = context.extractor.getValue(workingMemory, right);
            return !comparator.equals(value1, value2 = ((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value2;
            Object value1 = extractor1.getValue(workingMemory, object1);
            return !comparator.equals(value1, value2 = extractor2.getValue(workingMemory, object2));
        }

        public String toString() {
            return "Object !=";
        }
    }

    static class ObjectEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectEqualEvaluator();
        private static final ObjectEqualsComparator comparator = new ObjectEqualsComparator();

        private ObjectEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            return comparator.equals(value1, value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value2 = context.declaration.getExtractor().getValue(workingMemory, left);
            Object value1 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comparator.equals(value1, value2);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value1 = context.extractor.getValue(workingMemory, right);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            return comparator.equals(value1, value2);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            return comparator.equals(value1, value2);
        }

        public String toString() {
            return "Object ==";
        }
    }
}

