/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class DateFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = 400L;
    private static final String DEFAULT_FORMAT_MASK = "dd-MMM-yyyy";
    private static final String DATE_FORMAT_MASK = DateFactory.getDateFormatMask();
    private static EvaluatorFactory INSTANCE = new DateFactory();
    private static ThreadLocal df = new ThreadLocal(){

        protected Object initialValue() {
            return new SimpleDateFormat(DATE_FORMAT_MASK);
        }
    };

    private DateFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DateFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return DateEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return DateNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return DateLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return DateLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return DateGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return DateGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return DateMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return DateNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for DateEvaluator");
    }

    public static Date parseDate(String input) {
        try {
            return ((SimpleDateFormat)df.get()).parse(input);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid date input format: [" + input + "] it should follow: [" + DATE_FORMAT_MASK + "]");
        }
    }

    private static Date getRightDate(Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof String) {
            return DateFactory.parseDate((String)object2);
        }
        if (object2 instanceof Date) {
            return (Date)object2;
        }
        throw new IllegalArgumentException("Unable to convert " + object2.getClass() + " to a Date.");
    }

    private static String getDateFormatMask() {
        String fmt = System.getProperty("drools.dateformat");
        if (fmt == null) {
            fmt = DEFAULT_FORMAT_MASK;
        }
        return fmt;
    }

    static class DateNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateNotMemberOfEvaluator();

        private DateNotMemberOfEvaluator() {
            super(ValueType.DATE_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "Date not memberOf";
        }
    }

    static class DateMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateMemberOfEvaluator();

        private DateMemberOfEvaluator() {
            super(ValueType.DATE_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "Date memberOf";
        }
    }

    static class DateGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new DateGreaterOrEqualEvaluator();

        private DateGreaterOrEqualEvaluator() {
            super(ValueType.DATE_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value2;
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            return value1.compareTo(DateFactory.getRightDate(value2 = object2.getValue())) >= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return DateFactory.getRightDate(value2).compareTo(value1) >= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            return DateFactory.getRightDate(value2).compareTo(value1) >= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (null == value2) {
                throw new NullPointerException(extractor2.toString());
            }
            return value1.compareTo(value2) >= 0;
        }

        public String toString() {
            return "Date >=";
        }
    }

    static class DateGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateGreaterEvaluator();

        private DateGreaterEvaluator() {
            super(ValueType.DATE_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value2;
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            return value1.compareTo(DateFactory.getRightDate(value2 = object2.getValue())) > 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return DateFactory.getRightDate(value2).compareTo(value1) > 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            return DateFactory.getRightDate(value2).compareTo(value1) > 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (null == value2) {
                throw new NullPointerException(extractor2.toString());
            }
            return value1.compareTo(value2) > 0;
        }

        public String toString() {
            return "Date >";
        }
    }

    static class DateLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateLessOrEqualEvaluator();

        private DateLessOrEqualEvaluator() {
            super(ValueType.DATE_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value2;
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            return value1.compareTo(DateFactory.getRightDate(value2 = object2.getValue())) <= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return DateFactory.getRightDate(value2).compareTo(value1) <= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            return DateFactory.getRightDate(value2).compareTo(value1) <= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (null == value2) {
                throw new NullPointerException(extractor2.toString());
            }
            return value1.compareTo(value2) <= 0;
        }

        public String toString() {
            return "Date <=";
        }
    }

    static class DateLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateLessEvaluator();

        private DateLessEvaluator() {
            super(ValueType.DATE_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value2;
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            return value1.compareTo(DateFactory.getRightDate(value2 = object2.getValue())) < 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return DateFactory.getRightDate(value2).compareTo(value1) < 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            return DateFactory.getRightDate(value2).compareTo(value1) < 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (null == value2) {
                throw new NullPointerException(extractor2.toString());
            }
            return value1.compareTo(value2) < 0;
        }

        public String toString() {
            return "Date <";
        }
    }

    static class DateNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateNotEqualEvaluator();

        private DateNotEqualEvaluator() {
            super(ValueType.DATE_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 != null;
            }
            if (value2 == null) {
                return true;
            }
            return value1.compareTo(DateFactory.getRightDate(value2)) != 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value1 == null) {
                return value2 != null;
            }
            if (value2 == null) {
                return true;
            }
            return value1.compareTo(DateFactory.getRightDate(value2)) != 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            if (value1 == null) {
                return value2 != null;
            }
            if (value2 == null) {
                return true;
            }
            return value1.compareTo(DateFactory.getRightDate(value2)) != 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            if (value2 == null) {
                return true;
            }
            return value1.compareTo(value2) != 0;
        }

        public String toString() {
            return "Date !=";
        }
    }

    static class DateEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateEqualEvaluator();

        private DateEqualEvaluator() {
            super(ValueType.DATE_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 == null) {
                return false;
            }
            return value1.compareTo(DateFactory.getRightDate(value2)) == 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 == null) {
                return false;
            }
            return value1.compareTo(DateFactory.getRightDate(value2)) == 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 == null) {
                return false;
            }
            return value1.compareTo(DateFactory.getRightDate(value2)) == 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 == null) {
                return false;
            }
            return value1.compareTo(value2) == 0;
        }

        public String toString() {
            return "Date ==";
        }
    }
}

