/*
 * Decompiled with CFR 0.152.
 */
package org.drools.visualize;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.VertexFontFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import org.drools.visualize.VertexColorSet;
import org.drools.visualize.VertexLabelPaintFunction;

public class VertexFunctions
implements VertexStringer,
VertexFontFunction,
VertexShapeFunction,
VertexPaintFunction,
VertexLabelPaintFunction {
    private VertexColorSet defaultColors;
    private Graphics graphics;
    private Font font;

    public VertexFunctions() {
        BufferedImage image = new BufferedImage(100, 100, 1);
        this.graphics = image.createGraphics();
        this.defaultColors = new VertexColorSet();
        this.font = new Font("Verdana", 1, 10);
    }

    public void setDefaultColors(Color fill, Color stroke, Color text) {
        this.defaultColors = new VertexColorSet(fill, stroke, text);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Paint getLabelDrawPaint(Vertex vertex) {
        return this.defaultColors.getText();
    }

    public Font getFont(Vertex vertex) {
        return this.font;
    }

    public Shape getShape(Vertex vertex) {
        Dimension dim = this.getShapeDimension(vertex);
        return new RoundRectangle2D.Double(0 - dim.width / 2, 0 - dim.height / 2, dim.width, dim.height, 10.0, 10.0);
    }

    public Dimension getShapeDimension(Vertex vertex) {
        String label = this.getLabel((ArchetypeVertex)vertex);
        Font font = this.getFont(vertex);
        FontMetrics fm = this.graphics.getFontMetrics(this.getFont(vertex));
        int width = fm.stringWidth(label);
        int height = fm.getHeight();
        return new Dimension(width += font.getSize(), height += font.getSize());
    }

    public Paint getFillPaint(Vertex vertex) {
        return this.defaultColors.getFill();
    }

    public Paint getDrawPaint(Vertex vertex) {
        return this.defaultColors.getStroke();
    }

    public String getLabel(ArchetypeVertex vertex) {
        return "node";
    }
}

