/*
 * Decompiled with CFR 0.152.
 */
package org.drools.visualize;

import edu.uci.ics.jung.graph.Vertex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.visualize.Row;

public class RowList {
    private List rows = new ArrayList();

    public void add(int depth, Vertex vertex) {
        if (this.rows.size() < depth + 1) {
            int addRows = depth - this.rows.size() + 1;
            for (int i = 0; i < addRows; ++i) {
                this.rows.add(new Row(depth - addRows + i));
            }
        }
        ((Row)this.rows.get(depth)).add(vertex);
    }

    public int getDepth() {
        return this.rows.size();
    }

    public Row get(int row) {
        return (Row)this.rows.get(row);
    }

    public int getRow(Vertex vertex) {
        int numRows = this.rows.size();
        for (int i = 0; i < numRows; ++i) {
            if (!((Row)this.rows.get(i)).contains(vertex)) continue;
            return i;
        }
        return -1;
    }

    public int getWidth() {
        int width = 0;
        Iterator rowIter = this.rows.iterator();
        while (rowIter.hasNext()) {
            Row row = (Row)rowIter.next();
            int rowWidth = row.getWidth();
            if (rowWidth <= width) continue;
            width = rowWidth;
        }
        return width;
    }

    public int getWidth(int row) {
        return ((Row)this.rows.get(row)).getWidth();
    }

    public int getColumn(Vertex vertex) {
        int row = this.getRow(vertex);
        if (row < 0) {
            return -1;
        }
        List rowVertices = this.get(row).getVertices();
        int numCols = rowVertices.size();
        for (int i = 0; i < numCols; ++i) {
            if (!rowVertices.get(i).equals(vertex)) continue;
            return i;
        }
        return -1;
    }

    public void dump() {
        int numRows = this.rows.size();
        for (int i = 0; i < numRows; ++i) {
            System.err.println(i + ": " + this.get(i).getVertices());
        }
    }

    public void optimize() {
        int numRows = this.rows.size();
        for (int i = 0; i < numRows; ++i) {
            this.get(i).optimize();
        }
    }
}

