/*
 * Decompiled with CFR 0.152.
 */
package org.drools.visualize;

import edu.uci.ics.jung.graph.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Row {
    private int depth;
    private List vertices = new ArrayList();

    public Row(int depth) {
    }

    public int getDepth() {
        return this.depth;
    }

    public void add(Vertex vertex) {
        this.vertices.add(vertex);
    }

    public List getVertices() {
        return this.vertices;
    }

    public boolean contains(Vertex vertex) {
        return this.vertices.contains(vertex);
    }

    public int getWidth() {
        return this.vertices.size();
    }

    public void optimize() {
        ArrayList sorted = new ArrayList(this.vertices);
        Collections.sort(sorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                Vertex v1 = (Vertex)o1;
                Vertex v2 = (Vertex)o2;
                if (v1.outDegree() < v2.outDegree()) {
                    return 1;
                }
                if (v1.outDegree() > v2.outDegree()) {
                    return -1;
                }
                return 0;
            }
        });
        LinkedList<Vertex> optimized = new LinkedList<Vertex>();
        boolean front = false;
        Iterator vertexIter = sorted.iterator();
        while (vertexIter.hasNext()) {
            Vertex vertex = (Vertex)vertexIter.next();
            if (front) {
                optimized.addFirst(vertex);
            } else {
                optimized.addLast(vertex);
            }
            front = !front;
        }
        this.vertices = optimized;
    }
}

