/*
 * Decompiled with CFR 0.152.
 */
package org.drools.visualize;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserDataContainer;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.util.Iterator;
import java.util.Set;
import org.drools.visualize.RowList;
import org.drools.visualize.VertexFunctions;

public class ReteooLayout
extends AbstractLayout {
    public static final String COORDS = "drools.ReteooLayout.coords";
    private static final int COLUMN_SPACE = 20;
    private static final int ROW_HEIGHT_MULTIPLIER = 3;
    private RowList rowList;
    private VertexFunctions vertexFunctions;
    private int columnWidth;
    private int rowHeight;

    public ReteooLayout(Graph g, VertexFunctions vertexFunctions, RowList rowList) {
        super(g);
        this.vertexFunctions = vertexFunctions;
        this.rowList = rowList;
        this.computeSize();
    }

    public VertexFunctions getVertexFunctions() {
        return this.vertexFunctions;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getPreferredWidth() {
        return this.rowList.getWidth() * this.columnWidth;
    }

    public int getPreferredHeight() {
        return this.rowList.getDepth() * this.getRowHeight() * 3;
    }

    protected void computeSize() {
        Set vertices = this.getGraph().getVertices();
        Iterator vertexIter = vertices.iterator();
        while (vertexIter.hasNext()) {
            Vertex vertex = (Vertex)vertexIter.next();
            int width = this.vertexFunctions.getShapeDimension((Vertex)vertex).width;
            int height = this.vertexFunctions.getShapeDimension((Vertex)vertex).height;
            if (width > this.columnWidth) {
                this.columnWidth = width;
            }
            if (height <= this.rowHeight) continue;
            this.rowHeight = height;
        }
        this.columnWidth += 20;
    }

    protected void initialize_local_vertex(Vertex vertex) {
        int row = this.rowList.getRow(vertex);
        int col = this.rowList.getColumn(vertex);
        int widthPx = this.getCurrentSize().width;
        int heightPx = this.getCurrentSize().height;
        int rowWidth = this.rowList.getWidth(row);
        int columnWidthPx = this.getColumnWidth();
        int rowHeightPx = this.getRowHeight();
        Coordinates coords = new Coordinates();
        double x = col * columnWidthPx;
        double y = row * (rowHeightPx * 3);
        x = x + (double)(widthPx / 2) - (double)((rowWidth - 1) * (columnWidthPx / 2));
        y = y + (double)(rowHeightPx / 2) + 3.0;
        coords.setX(x);
        coords.setY(y);
        vertex.setUserDatum((Object)COORDS, (Object)coords, (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
    }

    public double getX(Vertex vertex) {
        return this.getCoordinates((ArchetypeVertex)vertex).getX();
    }

    public double getY(Vertex vertex) {
        return this.getCoordinates((ArchetypeVertex)vertex).getY();
    }

    public Coordinates getCoordinates(ArchetypeVertex vertex) {
        return (Coordinates)vertex.getUserDatum((Object)COORDS);
    }

    public void advancePositions() {
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean incrementsAreDone() {
        return false;
    }

    protected void initialize_local() {
    }
}

