/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.asm;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.drools.asm.ClassWriter;
import org.drools.asm.Label;
import org.drools.asm.MethodVisitor;
import org.drools.asm.Opcodes;
import org.drools.asm.Type;
import org.drools.util.asm.ClassFieldInspector;
import org.drools.util.asm.FieldAccessor;
import org.drools.util.asm.FieldAccessorMap;

public class FieldAccessorGenerator {
    private static FieldAccessorGenerator INSTANCE;
    private static final String GEN_PACKAGE_PREFIX = "org.drools.fieldaccess.";
    private final Map cache = new HashMap();
    static /* synthetic */ Class class$org$drools$util$asm$FieldAccessor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Void;

    private FieldAccessorGenerator() {
    }

    public static FieldAccessorGenerator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FieldAccessorGenerator();
        }
        return INSTANCE;
    }

    public FieldAccessorMap getInstanceFor(Class cls) throws Exception {
        Object obj = this.cache.get(cls);
        if (obj == null) {
            obj = this.newInstanceFor(cls);
            this.cache.put(cls, obj);
        }
        return (FieldAccessorMap)obj;
    }

    public FieldAccessorMap newInstanceFor(Class cls) throws Exception {
        ClassFieldInspector inspector = new ClassFieldInspector(cls);
        Method[] getters = inspector.getPropertyGetters().toArray(new Method[0]);
        String generatedClassName = GEN_PACKAGE_PREFIX + cls.getName();
        byte[] generatedClass = AccessorClassFactory.generateClass(getters, cls, generatedClassName);
        ByteArrayClassLoader cl = new ByteArrayClassLoader(Thread.currentThread().getContextClassLoader());
        cl.addByteArray(generatedClassName, generatedClass);
        FieldAccessor accessor = (FieldAccessor)cl.loadClass(generatedClassName).newInstance();
        FieldAccessorMap map = new FieldAccessorMap(accessor, inspector.getFieldNames());
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ByteArrayClassLoader
    extends ClassLoader {
        public ByteArrayClassLoader(ClassLoader parent) {
            super(parent);
        }

        public void addByteArray(String name, byte[] bytes) {
            this.defineClass(name, bytes, 0, bytes.length);
        }
    }

    static class AccessorClassFactory
    implements Opcodes {
        private static final String GET_FIELD_BY_INDEX_METHOD_NAME = "getFieldByIndex";

        AccessorClassFactory() {
        }

        private static String getShortName(Class cls) {
            String name = cls.getName();
            String packageName = cls.getPackage().getName();
            return name.substring(packageName.length() + 1, name.length());
        }

        public static byte[] generateClass(Method[] getters, Class targetClass, String generatedClassName) throws Exception {
            ClassWriter cw = new ClassWriter(true);
            generatedClassName = generatedClassName.replaceAll("\\.", "/");
            cw.visit(46, 33, generatedClassName, null, "java/lang/Object", new String[]{Type.getInternalName(class$org$drools$util$asm$FieldAccessor == null ? (class$org$drools$util$asm$FieldAccessor = FieldAccessorGenerator.class$("org.drools.util.asm.FieldAccessor")) : class$org$drools$util$asm$FieldAccessor)});
            cw.visitSource(AccessorClassFactory.getShortName(targetClass) + ".java", null);
            AccessorClassFactory.doConstructor(cw);
            AccessorClassFactory.doMethods(cw, Type.getInternalName(targetClass), getters, targetClass.isInterface());
            cw.visitEnd();
            return cw.toByteArray();
        }

        private static void doMethods(ClassWriter cw, String targetType, Method[] getters, boolean isInterface) {
            MethodVisitor mv = cw.visitMethod(1, GET_FIELD_BY_INDEX_METHOD_NAME, "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
            mv.visitCode();
            Label entry = new Label();
            mv.visitLabel(entry);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, targetType);
            int target = 3;
            mv.visitVarInsn(58, target);
            Label start = new Label();
            mv.visitLabel(start);
            mv.visitVarInsn(21, 2);
            Label[] switchItems = new Label[getters.length];
            for (int i = 0; i < getters.length; ++i) {
                switchItems[i] = new Label();
            }
            Label defaultSwitch = new Label();
            mv.visitTableSwitchInsn(0, switchItems.length - 1, defaultSwitch, switchItems);
            for (int i = 0; i < getters.length; ++i) {
                Method method = getters[i];
                if (method.getReturnType().isPrimitive()) {
                    AccessorClassFactory.doSwitchItemBoxed(mv, switchItems[i], target, targetType, method.getName(), method.getReturnType(), isInterface);
                    continue;
                }
                AccessorClassFactory.doSwitchItemObject(mv, switchItems[i], target, targetType, method.getName(), method.getReturnType(), isInterface);
            }
            mv.visitLabel(defaultSwitch);
            mv.visitInsn(1);
            mv.visitInsn(176);
            Label endLabel = new Label();
            mv.visitLabel(endLabel);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private static void doSwitchItemBoxed(MethodVisitor mv, Label switchItem, int target, String targetType, String targetMethod, Class scalarType, boolean isInterface) {
            Class boxType = null;
            boxType = AccessorClassFactory.getBoxType(scalarType);
            String scalarDescriptor = Type.getDescriptor(scalarType);
            String internalBoxName = Type.getInternalName(boxType);
            mv.visitLabel(switchItem);
            mv.visitTypeInsn(187, internalBoxName);
            mv.visitInsn(89);
            mv.visitVarInsn(25, target);
            if (isInterface) {
                mv.visitMethodInsn(185, targetType, targetMethod, "()" + scalarDescriptor);
            } else {
                mv.visitMethodInsn(182, targetType, targetMethod, "()" + scalarDescriptor);
            }
            mv.visitMethodInsn(183, internalBoxName, "<init>", "(" + scalarDescriptor + ")V");
            mv.visitInsn(176);
        }

        private static Class getBoxType(Class scalarType) {
            if (scalarType == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = FieldAccessorGenerator.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (scalarType == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = FieldAccessorGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (scalarType == Character.TYPE) {
                return class$java$lang$Character == null ? (class$java$lang$Character = FieldAccessorGenerator.class$("java.lang.Character")) : class$java$lang$Character;
            }
            if (scalarType == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = FieldAccessorGenerator.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            if (scalarType == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = FieldAccessorGenerator.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (scalarType == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = FieldAccessorGenerator.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (scalarType == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = FieldAccessorGenerator.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (scalarType == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = FieldAccessorGenerator.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (scalarType == Void.TYPE) {
                return class$java$lang$Void == null ? (class$java$lang$Void = FieldAccessorGenerator.class$("java.lang.Void")) : class$java$lang$Void;
            }
            throw new IllegalArgumentException("Unknown scalar type: " + scalarType.getName());
        }

        private static void doSwitchItemObject(MethodVisitor mv, Label label, int target, String targetType, String targetMethod, Class returnClass, boolean isInterface) {
            String returnType = "()" + Type.getDescriptor(returnClass);
            mv.visitLabel(label);
            mv.visitVarInsn(25, target);
            if (isInterface) {
                mv.visitMethodInsn(185, targetType, targetMethod, returnType);
            } else {
                mv.visitMethodInsn(182, targetType, targetMethod, returnType);
            }
            mv.visitInsn(176);
        }

        private static void doConstructor(ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(5, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
            mv.visitInsn(177);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }
}

