/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.asm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.asm.AnnotationVisitor;
import org.drools.asm.Attribute;
import org.drools.asm.ClassReader;
import org.drools.asm.ClassVisitor;
import org.drools.asm.FieldVisitor;
import org.drools.asm.MethodVisitor;

public class ClassFieldInspector {
    private List methods = new ArrayList();
    private Map fieldNames = new HashMap();
    private Map fieldTypes = new HashMap();
    private Map methodNames = new HashMap();
    private Set nonGetters = new HashSet();

    public ClassFieldInspector(Class clazz) throws IOException {
        this.processClass(clazz);
    }

    private void processClass(Class clazz) throws IOException {
        String name = this.getResourcePath(clazz);
        InputStream stream = clazz.getResourceAsStream(name);
        ClassReader reader = new ClassReader(stream);
        ClassFieldVisitor visitor = new ClassFieldVisitor(clazz, this);
        reader.accept(visitor, false);
        if (clazz.getSuperclass() != null) {
            this.processClass(clazz.getSuperclass());
        }
        if (clazz.isInterface()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.processClass(interfaces[i]);
            }
        }
    }

    private String getResourcePath(Class clazz) {
        return "/" + clazz.getName().replace('.', '/') + ".class";
    }

    public List getPropertyGetters() {
        return this.methods;
    }

    public Map getFieldNames() {
        return this.fieldNames;
    }

    public Map getFieldTypes() {
        return this.fieldTypes;
    }

    public Map getGetterMethods() {
        return this.methodNames;
    }

    static class ClassFieldAnnotationVisitor
    implements AnnotationVisitor {
        ClassFieldAnnotationVisitor() {
        }

        public void visit(String arg0, Object arg1) {
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
        }

        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            return new ClassFieldAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String arg0) {
            return new ClassFieldAnnotationVisitor();
        }

        public void visitEnd() {
        }
    }

    static class ClassFieldVisitor
    implements ClassVisitor {
        private Class clazz;
        private ClassFieldInspector inspector;

        ClassFieldVisitor(Class cls, ClassFieldInspector inspector) {
            this.clazz = cls;
            this.inspector = inspector;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 1) > 0 && desc.startsWith("()") && !name.equals("<init>")) {
                try {
                    Method method = this.clazz.getMethod(name, null);
                    if (method.getReturnType() != Void.TYPE) {
                        int fieldIndex = this.inspector.methods.size();
                        this.addToMapping(method, fieldIndex);
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Error in getting field access method.");
                }
            }
            return null;
        }

        public void visit(int arg0, int arg1, String arg2, String arg3, String[] arg4, String arg5) {
        }

        public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
        }

        public void visitField(int access, String arg1, String arg2, Object arg3, Attribute arg4) {
        }

        public void visitAttribute(Attribute arg0) {
        }

        public void visitEnd() {
        }

        public void visit(int arg0, int arg1, String arg2, String arg3, String arg4, String[] arg5) {
        }

        public void visitSource(String arg0, String arg1) {
        }

        public void visitOuterClass(String arg0, String arg1, String arg2) {
        }

        public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
            return new ClassFieldAnnotationVisitor();
        }

        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            return null;
        }

        private void addToMapping(Method method, int index) {
            String name = method.getName();
            int offset = name.startsWith("is") ? 2 : (name.startsWith("get") ? 3 : 0);
            String fieldName = this.calcFieldName(name, offset);
            if (this.inspector.fieldNames.containsKey(fieldName)) {
                if (offset != 0 && this.inspector.nonGetters.contains(fieldName)) {
                    this.removeOldField(fieldName);
                    this.storeField(method, index, fieldName);
                    this.inspector.nonGetters.remove(fieldName);
                }
            } else {
                this.storeField(method, index, fieldName);
                if (offset == 0) {
                    this.inspector.nonGetters.add(fieldName);
                }
            }
        }

        private void removeOldField(String fieldName) {
            this.inspector.fieldNames.remove(fieldName);
            this.inspector.fieldTypes.remove(fieldName);
            this.inspector.methods.remove(this.inspector.methodNames.get(fieldName));
            this.inspector.methodNames.remove(fieldName);
        }

        private void storeField(Method method, int index, String fieldName) {
            this.inspector.fieldNames.put(fieldName, new Integer(index));
            this.inspector.fieldTypes.put(fieldName, method.getReturnType());
            this.inspector.methodNames.put(fieldName, method);
            this.inspector.methods.add(method);
        }

        private String calcFieldName(String name, int offset) {
            name = name.substring(offset);
            char first = Character.toLowerCase(name.charAt(0));
            name = first + name.substring(1);
            return name;
        }
    }
}

