/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.common.ObjectInputStreamWithLoader;
import org.drools.rule.EvalCondition;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.spi.Consequence;
import org.drools.spi.EvalExpression;
import org.drools.spi.PredicateExpression;
import org.drools.spi.ReturnValueExpression;

public class PackageCompilationData
implements Externalizable {
    private Map invokerLookups = new HashMap();
    private Object AST;
    private Map store = new HashMap();
    private transient PackageClassLoader classLoader;
    private transient ClassLoader parentClassLoader;

    public PackageCompilationData() {
        this(null);
    }

    public PackageCompilationData(ClassLoader parentClassLoader) {
        this.init(parentClassLoader);
    }

    private void init(ClassLoader parentClassLoader) {
        if (parentClassLoader == null && (parentClassLoader = Thread.currentThread().getContextClassLoader()) == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        this.parentClassLoader = parentClassLoader;
        this.classLoader = new PackageClassLoader(this.parentClassLoader);
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.store);
        stream.writeObject(this.AST);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.invokerLookups);
        stream.writeObject(bos.toByteArray());
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.init(null);
        this.store = (Map)stream.readObject();
        this.AST = stream.readObject();
        byte[] bytes = (byte[])stream.readObject();
        ObjectInputStreamWithLoader streamWithLoader = new ObjectInputStreamWithLoader(new ByteArrayInputStream(bytes), this.classLoader);
        this.invokerLookups = (Map)streamWithLoader.readObject();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public byte[] read(String resourceName) {
        byte[] bytes = null;
        if (this.store != null) {
            return (byte[])this.store.get(resourceName.replace('.', '/') + ".class");
        }
        return bytes;
    }

    public void write(String resourceName, byte[] clazzData) throws RuntimeDroolsException {
        if (this.store.put(resourceName.replace('.', '/') + ".class", clazzData) != null) {
            this.reload();
        } else {
            try {
                this.wire(resourceName);
            }
            catch (Exception e) {
                throw new RuntimeDroolsException(e);
            }
        }
    }

    public void remove(String resourceName) throws RuntimeDroolsException {
        this.invokerLookups.remove(resourceName);
        if (this.store.remove(resourceName.replace('.', '/') + ".class") != null) {
            this.reload();
        }
    }

    public String[] list() {
        if (this.store == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = this.store.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            names.add(name.replace('/', '.').substring(0, name.length() - 6));
        }
        return names.toArray(new String[this.store.size()]);
    }

    public void reload() throws RuntimeDroolsException {
        this.classLoader = new PackageClassLoader(this.parentClassLoader);
        try {
            Iterator it = this.invokerLookups.keySet().iterator();
            while (it.hasNext()) {
                this.wire((String)it.next());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationError e) {
            throw new RuntimeDroolsException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public void clear() {
        this.store.clear();
        this.invokerLookups.clear();
        this.AST = null;
        this.reload();
    }

    public void wire(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object invoker = this.invokerLookups.get(className);
        this.wire(className, invoker);
    }

    public void wire(String className, Object invoker) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz = this.classLoader.findClass(className);
        if (invoker instanceof ReturnValueConstraint) {
            ((ReturnValueConstraint)invoker).setReturnValueExpression((ReturnValueExpression)clazz.newInstance());
        } else if (invoker instanceof PredicateConstraint) {
            ((PredicateConstraint)invoker).setPredicateExpression((PredicateExpression)clazz.newInstance());
        } else if (invoker instanceof EvalCondition) {
            ((EvalCondition)invoker).setEvalExpression((EvalExpression)clazz.newInstance());
        } else if (invoker instanceof Rule) {
            ((Rule)invoker).setConsequence((Consequence)clazz.newInstance());
        }
    }

    public String toString() {
        return this.getClass().getName() + this.store.toString();
    }

    public void putInvoker(String className, Object invoker) {
        this.invokerLookups.put(className, invoker);
    }

    public void putAllInvokers(Map invokers) {
        this.invokerLookups.putAll(invokers);
    }

    public Map getInvokers() {
        return this.invokerLookups;
    }

    public void removeInvoker(String className) {
        this.invokerLookups.remove(className);
    }

    public Object getAST() {
        return this.AST;
    }

    public void setAST(Object ast) {
        this.AST = ast;
    }

    public class PackageClassLoader
    extends ClassLoader {
        public PackageClassLoader(ClassLoader parentClassLoader) {
            super(parentClassLoader);
        }

        public Class fastFindClass(String name) {
            byte[] clazzBytes;
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null && (clazzBytes = PackageCompilationData.this.read(name)) != null) {
                return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
            }
            return clazz;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.fastFindClass(name);
            if (clazz == null) {
                ClassLoader parent = this.getParent();
                if (parent != null) {
                    clazz = parent.loadClass(name);
                } else {
                    throw new ClassNotFoundException(name);
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            Class clazz = this.fastFindClass(name);
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
            return clazz;
        }

        public InputStream getResourceAsStream(String name) {
            byte[] bytes = (byte[])PackageCompilationData.this.store.get(name);
            if (bytes != null) {
                return new ByteArrayInputStream(bytes);
            }
            return super.getResourceAsStream(name);
        }
    }
}

