/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.rule.PackageCompilationData;

public class CompositePackageClassLoader
extends ClassLoader {
    private List classLoaders = new ArrayList();

    public CompositePackageClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void removeClassLoader(ClassLoader classLoader) {
        Iterator it = this.classLoaders.iterator();
        while (it.hasNext()) {
            if (it.next() != classLoader) continue;
            it.remove();
            break;
        }
    }

    private Class compositeFastFindClass(String name) {
        Iterator it = this.classLoaders.iterator();
        while (it.hasNext()) {
            PackageCompilationData.PackageClassLoader classLoader = (PackageCompilationData.PackageClassLoader)it.next();
            Class clazz = classLoader.fastFindClass(name);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null && (clazz = this.compositeFastFindClass(name)) == null) {
            ClassLoader parent = this.getParent();
            if (parent != null) {
                clazz = parent.loadClass(name);
            } else {
                throw new ClassNotFoundException(name);
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class clazz = this.compositeFastFindClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }
}

