/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.rule.Declaration;
import org.drools.spi.ColumnExtractor;
import org.drools.spi.Extractor;
import org.drools.spi.FieldConstraint;
import org.drools.spi.ObjectType;

public class Column
implements Serializable {
    private final ObjectType objectType;
    private List constraints = Collections.EMPTY_LIST;
    final Declaration declaration;
    private final int index;
    private int offset;

    public Column(int index, ObjectType objectType) {
        this(index, 0, objectType, null);
    }

    public Column(int index, ObjectType objectType, String identifier) {
        this(index, 0, objectType, identifier);
    }

    public Column(int index, int offset, ObjectType objectType, String identifier) {
        this.index = index;
        this.offset = offset;
        this.objectType = objectType;
        this.declaration = identifier != null ? new Declaration(identifier, new ColumnExtractor(objectType), this.getFactIndex()) : null;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public List getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public void addConstraint(FieldConstraint constraint) {
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList(1);
        }
        this.constraints.add(constraint);
    }

    public Declaration addDeclaration(String identifier, Extractor extractor) {
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList(1);
        }
        Declaration declaration = new Declaration(identifier, extractor, this.getFactIndex());
        this.constraints.add(declaration);
        return declaration;
    }

    public boolean isBound() {
        return this.declaration != null;
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getFactIndex() {
        return this.index + this.offset;
    }

    public void adjustOffset(int adjust) {
        this.offset += adjust;
        if (this.declaration != null) {
            this.declaration.setColumn(this.getFactIndex());
        }
        Iterator i = this.constraints.iterator();
        while (i.hasNext()) {
            Object constr = i.next();
            if (!(constr instanceof Declaration)) continue;
            ((Declaration)constr).setColumn(this.getFactIndex());
        }
    }

    public String toString() {
        return "Column type='" + this.objectType + "', index='" + this.index + "', offset='" + this.getOffset() + "', identifer='" + this.declaration.getIdentifier() + "'";
    }
}

