/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.beta;

import javax.naming.OperationNotSupportedException;
import org.drools.common.BetaNodeBinder;
import org.drools.reteoo.beta.BetaLeftMemory;
import org.drools.reteoo.beta.BetaRightMemory;
import org.drools.reteoo.beta.BooleanConstrainedLeftMemory;
import org.drools.reteoo.beta.BooleanConstrainedRightMemory;
import org.drools.reteoo.beta.DefaultLeftMemory;
import org.drools.reteoo.beta.DefaultRightMemory;
import org.drools.reteoo.beta.ObjectEqualConstrLeftMemory;
import org.drools.reteoo.beta.ObjectEqualConstrRightMemory;
import org.drools.reteoo.beta.ObjectNotEqualConstrLeftMemory;
import org.drools.reteoo.beta.ObjectNotEqualConstrRightMemory;
import org.drools.rule.BoundVariableConstraint;
import org.drools.spi.FieldConstraint;

public class BetaMemoryFactory {
    private static final String INDEX_DISABLED = "false";
    private static final String INDEX_ENABLED = "true";
    public static final String INDEX_LEFT_BETA_MEMORY = "org.drools.reteoo.beta.index-left";
    public static final String INDEX_RIGHT_BETA_MEMORY = "org.drools.reteoo.beta.index-right";

    protected BetaMemoryFactory() {
    }

    public static BetaLeftMemory newLeftMemory(BetaNodeBinder binder) {
        FieldConstraint[] constraints;
        DefaultLeftMemory memory = null;
        BetaLeftMemory innerMostMemory = null;
        FieldConstraint[] fieldConstraintArray = constraints = binder != null ? binder.getConstraints() : null;
        if (constraints != null && INDEX_ENABLED.equalsIgnoreCase(System.getProperty(INDEX_LEFT_BETA_MEMORY))) {
            for (int i = 0; i < constraints.length; ++i) {
                if (!(constraints[i] instanceof BoundVariableConstraint)) continue;
                BoundVariableConstraint bvc = (BoundVariableConstraint)constraints[i];
                BetaLeftMemory innerMemory = null;
                switch (bvc.getEvaluator().getType()) {
                    case 170: {
                        innerMemory = new BooleanConstrainedLeftMemory(bvc.getFieldExtractor(), bvc.getRequiredDeclarations()[0], bvc.getEvaluator());
                        break;
                    }
                    case 110: 
                    case 120: 
                    case 130: 
                    case 150: 
                    case 160: 
                    case 210: {
                        if (bvc.getEvaluator().getOperator() == 1) {
                            innerMemory = new ObjectEqualConstrLeftMemory(bvc.getFieldExtractor(), bvc.getRequiredDeclarations()[0], bvc.getEvaluator());
                            break;
                        }
                        if (bvc.getEvaluator().getOperator() != 10) break;
                        innerMemory = new ObjectNotEqualConstrLeftMemory(bvc.getFieldExtractor(), bvc.getRequiredDeclarations()[0], bvc.getEvaluator());
                    }
                }
                if (innerMemory == null) continue;
                if (innerMostMemory != null) {
                    try {
                        innerMostMemory.setInnerMemory(innerMemory);
                        innerMostMemory = innerMemory;
                        continue;
                    }
                    catch (OperationNotSupportedException e) {
                        throw new RuntimeException("BUG: Exception was not supposed to be raised", e);
                    }
                }
                memory = innerMemory;
                innerMostMemory = memory;
            }
        }
        if (memory == null) {
            memory = new DefaultLeftMemory();
        }
        return memory;
    }

    public static BetaRightMemory newRightMemory(BetaNodeBinder binder) {
        FieldConstraint[] constraints;
        DefaultRightMemory memory = null;
        BetaRightMemory innerMostMemory = null;
        FieldConstraint[] fieldConstraintArray = constraints = binder != null ? binder.getConstraints() : null;
        if (constraints != null && !INDEX_DISABLED.equalsIgnoreCase(System.getProperty(INDEX_RIGHT_BETA_MEMORY))) {
            for (int i = 0; i < constraints.length; ++i) {
                if (!(constraints[i] instanceof BoundVariableConstraint)) continue;
                BoundVariableConstraint bvc = (BoundVariableConstraint)constraints[i];
                BetaRightMemory innerMemory = null;
                switch (bvc.getEvaluator().getType()) {
                    case 170: {
                        innerMemory = new BooleanConstrainedRightMemory(bvc.getFieldExtractor(), bvc.getRequiredDeclarations()[0], bvc.getEvaluator());
                        break;
                    }
                    case 110: 
                    case 120: 
                    case 130: 
                    case 150: 
                    case 160: 
                    case 210: {
                        if (bvc.getEvaluator().getOperator() == 1) {
                            innerMemory = new ObjectEqualConstrRightMemory(bvc.getFieldExtractor(), bvc.getRequiredDeclarations()[0], bvc.getEvaluator());
                            break;
                        }
                        if (bvc.getEvaluator().getOperator() != 10) break;
                        innerMemory = new ObjectNotEqualConstrRightMemory(bvc.getFieldExtractor(), bvc.getRequiredDeclarations()[0], bvc.getEvaluator());
                    }
                }
                if (innerMemory == null) continue;
                if (innerMostMemory != null) {
                    try {
                        innerMostMemory.setInnerMemory(innerMemory);
                        innerMostMemory = innerMemory;
                        continue;
                    }
                    catch (OperationNotSupportedException e) {
                        throw new RuntimeException("BUG: Exception was not supposed to be raised", e);
                    }
                }
                memory = innerMemory;
                innerMostMemory = memory;
            }
        }
        if (memory == null) {
            memory = new DefaultRightMemory();
        }
        return memory;
    }
}

