/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.common.BetaNodeBinder;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.ObjectMatches;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleMatch;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.PropagationContext;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListNode;
import org.drools.util.LinkedListObjectWrapper;

abstract class TupleSource
extends BaseNode
implements Serializable {
    protected List tupleSinks = new ArrayList(1);

    TupleSource(int id) {
        super(id);
    }

    protected void addTupleSink(TupleSink tupleSink) {
        if (!this.tupleSinks.contains(tupleSink)) {
            this.tupleSinks.add(tupleSink);
        }
    }

    protected void removeTupleSink(TupleSink tupleSink) {
        this.tupleSinks.remove(tupleSink);
    }

    protected TupleMatch attemptJoin(ReteTuple leftTuple, FactHandleImpl handle, ObjectMatches objectMatches, BetaNodeBinder binder, WorkingMemoryImpl workingMemory) {
        if (binder.isAllowed(handle, leftTuple, workingMemory)) {
            TupleMatch tupleMatch = objectMatches.add(leftTuple);
            leftTuple.addTupleMatch(handle, tupleMatch);
            return tupleMatch;
        }
        return null;
    }

    protected void propagateAssertTuple(ReteTuple tuple, TupleMatch tupleMatch, PropagationContext context, WorkingMemoryImpl workingMemory) {
        if (!this.getTupleSinks().isEmpty()) {
            ((TupleSink)this.getTupleSinks().get(0)).assertTuple(tuple, context, workingMemory);
            tupleMatch.addJoinedTuple(tuple);
            int size = this.getTupleSinks().size();
            for (int i = 1; i < size; ++i) {
                ReteTuple clone = new ReteTuple(tuple);
                tupleMatch.addJoinedTuple(clone);
                ((TupleSink)this.getTupleSinks().get(i)).assertTuple(clone, context, workingMemory);
            }
        }
    }

    protected void propagateAssertTuple(ReteTuple tuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        int size = this.getTupleSinks().size();
        for (int i = 0; i < size; ++i) {
            ReteTuple child = new ReteTuple(tuple);
            tuple.addLinkedTuple(new LinkedListObjectWrapper(child));
            ((TupleSink)this.getTupleSinks().get(i)).assertTuple(child, context, workingMemory);
        }
    }

    protected void propagateRetractTuple(TupleMatch tupleMatch, PropagationContext context, WorkingMemoryImpl workingMemory) {
        List joined = tupleMatch.getJoinedTuples();
        int size = joined.size();
        for (int i = 0; i < size; ++i) {
            ((TupleSink)this.getTupleSinks().get(i)).retractTuple((ReteTuple)joined.get(i), context, workingMemory);
        }
    }

    protected void propagateRetractTuple(ReteTuple tuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        LinkedList list = tuple.getLinkedTuples();
        if (list != null && !list.isEmpty()) {
            int i = 0;
            LinkedListNode node = list.removeFirst();
            while (node != null) {
                ((TupleSink)this.getTupleSinks().get(i++)).retractTuple((ReteTuple)((LinkedListObjectWrapper)node).getObject(), context, workingMemory);
                node = list.removeFirst();
            }
        }
    }

    protected void propagateModifyTuple(TupleMatch tupleMatch, PropagationContext context, WorkingMemoryImpl workingMemory) {
        List joined = tupleMatch.getJoinedTuples();
        int size = joined.size();
        for (int i = 0; i < size; ++i) {
            ((TupleSink)this.getTupleSinks().get(i)).modifyTuple((ReteTuple)joined.get(i), context, workingMemory);
        }
    }

    protected void propagateModifyTuple(ReteTuple tuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        LinkedList list = tuple.getLinkedTuples();
        if (list != null && !list.isEmpty()) {
            int i = 0;
            for (LinkedListNode node = list.getFirst(); node != null; node = node.getNext()) {
                ((TupleSink)this.getTupleSinks().get(i++)).modifyTuple((ReteTuple)((LinkedListObjectWrapper)node).getObject(), context, workingMemory);
            }
        }
    }

    public List getTupleSinks() {
        return this.tupleSinks;
    }

    public abstract List getPropagatedTuples(WorkingMemoryImpl var1, TupleSink var2);
}

