/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Iterator;
import org.drools.common.Agenda;
import org.drools.common.AgendaGroupImpl;
import org.drools.common.AgendaItem;
import org.drools.common.PropagationContextImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.NodeMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.Duration;
import org.drools.spi.PropagationContext;

final class TerminalNode
extends BaseNode
implements TupleSink,
NodeMemory {
    private final Rule rule;
    private final TupleSource tupleSource;
    static /* synthetic */ Class class$org$drools$reteoo$TerminalNode;

    TerminalNode(int id, TupleSource source, Rule rule) {
        super(id);
        this.rule = rule;
        this.tupleSource = source;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        this.assertTuple(tuple, context, workingMemory, true);
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, WorkingMemoryImpl workingMemory, boolean fireActivationCreated) {
        if (this.rule.getNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            return;
        }
        Agenda agenda = workingMemory.getAgenda();
        Duration dur = this.rule.getDuration();
        if (dur != null && dur.getDuration(tuple) > 0L) {
            ScheduledAgendaItem item = new ScheduledAgendaItem(context.getPropagationNumber(), tuple, workingMemory.getAgenda(), context, this.rule);
            if (this.rule.getActivationGroup() != null) {
                TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
                if (memory.getActivationGroup() == null) {
                    memory.setActivationGroup(workingMemory.getAgenda().getActivationGroup(this.rule.getActivationGroup()));
                }
                memory.getActivationGroup().addActivation(item);
            }
            agenda.scheduleItem(item);
            tuple.setActivation(item);
            item.setActivated(true);
            workingMemory.getAgendaEventSupport().fireActivationCreated(item);
        } else {
            TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
            AgendaGroupImpl agendaGroup = memory.getAgendaGroup();
            if (agendaGroup == null) {
                agendaGroup = this.rule.getAgendaGroup() == null || this.rule.getAgendaGroup().equals("") || this.rule.getAgendaGroup().equals("MAIN") ? (AgendaGroupImpl)agenda.getAgendaGroup("MAIN") : (AgendaGroupImpl)agenda.getAgendaGroup(this.rule.getAgendaGroup());
                if (agendaGroup == null) {
                    agendaGroup = new AgendaGroupImpl(this.rule.getAgendaGroup());
                    workingMemory.getAgenda().addAgendaGroup(agendaGroup);
                }
                memory.setAgendaGroup(agendaGroup);
            }
            if (this.rule.getAutoFocus()) {
                agenda.setFocus(agendaGroup);
            }
            AgendaItem item = new AgendaItem(context.getPropagationNumber(), tuple, context, this.rule);
            if (this.rule.getActivationGroup() != null) {
                if (memory.getActivationGroup() == null) {
                    memory.setActivationGroup(workingMemory.getAgenda().getActivationGroup(this.rule.getActivationGroup()));
                }
                memory.getActivationGroup().addActivation(item);
            }
            agendaGroup.add(item);
            tuple.setActivation(item);
            item.setActivated(true);
            if (fireActivationCreated) {
                workingMemory.getAgendaEventSupport().fireActivationCreated(item);
            }
        }
    }

    public void retractTuple(ReteTuple tuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        Activation activation = tuple.getActivation();
        if (activation.isActivated()) {
            activation.remove();
            workingMemory.getAgendaEventSupport().fireActivationCancelled(activation);
        }
        workingMemory.removeLogicalDependencies(activation, context, this.rule);
    }

    public void modifyTuple(ReteTuple tuple, PropagationContext context, WorkingMemoryImpl workingMemory) {
        if (tuple.getActivation().isActivated()) {
            tuple.getActivation().remove();
        }
        this.assertTuple(tuple, context, workingMemory, false);
    }

    public String toString() {
        return "[TerminalNode: rule=" + this.rule.getName() + "]";
    }

    public void ruleAttached() {
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(WorkingMemoryImpl[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            WorkingMemoryImpl workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateNewNode(workingMemory, propagationContext);
        }
    }

    public void remove(BaseNode node, WorkingMemoryImpl[] workingMemories) {
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            WorkingMemoryImpl workingMemory = workingMemories[i];
            Iterator it = this.tupleSource.getPropagatedTuples(workingMemory, this).iterator();
            while (it.hasNext()) {
                ReteTuple tuple = (ReteTuple)it.next();
                Activation activation = tuple.getActivation();
                if (activation.isActivated()) {
                    activation.remove();
                    workingMemory.getAgendaEventSupport().fireActivationCancelled(activation);
                }
                PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 4, null, null);
                workingMemory.removeLogicalDependencies(activation, propagationContext, this.rule);
            }
            workingMemory.propagateQueuedActions();
        }
        this.tupleSource.remove(this, workingMemories);
    }

    public void updateNewNode(WorkingMemoryImpl workingMemory, PropagationContext context) {
    }

    public Object createMemory() {
        return new TerminalNodeMemory();
    }

    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != (class$org$drools$reteoo$TerminalNode == null ? (class$org$drools$reteoo$TerminalNode = TerminalNode.class$("org.drools.reteoo.TerminalNode")) : class$org$drools$reteoo$TerminalNode)) {
            return false;
        }
        TerminalNode other = (TerminalNode)object;
        return this.rule.equals(other.rule);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TerminalNodeMemory {
        private AgendaGroupImpl agendaGroup;
        private ActivationGroup activationGroup;

        TerminalNodeMemory() {
        }

        public AgendaGroupImpl getAgendaGroup() {
            return this.agendaGroup;
        }

        public void setAgendaGroup(AgendaGroupImpl agendaGroup) {
            this.agendaGroup = agendaGroup;
        }

        public ActivationGroup getActivationGroup() {
            return this.activationGroup;
        }

        public void setActivationGroup(ActivationGroup activationGroup) {
            this.activationGroup = activationGroup;
        }
    }
}

