/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.PackageIntegrationException;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.common.ObjectInputStreamWithLoader;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.DefaultFactHandleFactory;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.InitialFactHandle;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.CompositePackageClassLoader;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Package;
import org.drools.rule.PackageCompilationData;
import org.drools.rule.Rule;
import org.drools.spi.ClassObjectTypeResolver;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.PropagationContext;

public class RuleBaseImpl
implements RuleBase,
Externalizable {
    private Map pkgs;
    private transient CompositePackageClassLoader packageClassLoader;
    private Rete rete;
    private ReteooBuilder reteooBuilder;
    private FactHandleFactory factHandleFactory;
    private Map globals;
    private transient Map workingMemories;
    private static final Object PRESENT = new Object();

    public RuleBaseImpl() {
        this(new DefaultFactHandleFactory());
    }

    public RuleBaseImpl(FactHandleFactory factHandleFactory) {
        ClassObjectTypeResolver resolver = new ClassObjectTypeResolver();
        this.rete = new Rete(resolver);
        this.reteooBuilder = new ReteooBuilder(this, resolver);
        this.factHandleFactory = factHandleFactory;
        this.packageClassLoader = new CompositePackageClassLoader(Thread.currentThread().getContextClassLoader());
        this.pkgs = new HashMap();
        this.globals = new HashMap();
        this.workingMemories = new WeakHashMap();
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.pkgs);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.rete);
        out.writeObject(this.reteooBuilder);
        out.writeObject(this.factHandleFactory);
        out.writeObject(this.globals);
        stream.writeObject(bos.toByteArray());
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.pkgs = (Map)stream.readObject();
        this.packageClassLoader = new CompositePackageClassLoader(Thread.currentThread().getContextClassLoader());
        Iterator it = this.pkgs.values().iterator();
        while (it.hasNext()) {
            this.packageClassLoader.addClassLoader(((Package)it.next()).getPackageCompilationData().getClassLoader());
        }
        byte[] bytes = (byte[])stream.readObject();
        ObjectInputStreamWithLoader streamWithLoader = new ObjectInputStreamWithLoader(new ByteArrayInputStream(bytes), this.packageClassLoader);
        this.rete = (Rete)streamWithLoader.readObject();
        this.reteooBuilder = (ReteooBuilder)streamWithLoader.readObject();
        this.reteooBuilder.setRuleBase(this);
        this.reteooBuilder.setRete(this.rete);
        this.factHandleFactory = (FactHandleFactory)streamWithLoader.readObject();
        this.globals = (Map)streamWithLoader.readObject();
        this.workingMemories = new WeakHashMap();
    }

    public WorkingMemory newWorkingMemory() {
        return this.newWorkingMemory(true);
    }

    public WorkingMemory newWorkingMemory(boolean keepReference) {
        WorkingMemoryImpl workingMemory = new WorkingMemoryImpl(this);
        if (keepReference) {
            this.workingMemories.put(workingMemory, PRESENT);
        }
        InitialFactHandle handle = new InitialFactHandle((FactHandleImpl)workingMemory.newFactHandle());
        PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 0, null, null);
        this.assertObject(handle, handle.getObject(), propagationContext, workingMemory);
        return workingMemory;
    }

    void disposeWorkingMemory(WorkingMemory workingMemory) {
        this.workingMemories.remove(workingMemory);
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.factHandleFactory;
    }

    public FactHandleFactory newFactHandleFactory() {
        return this.factHandleFactory.newInstance();
    }

    Rete getRete() {
        return this.rete;
    }

    void assertObject(FactHandle handle, Object object, PropagationContext context, WorkingMemoryImpl workingMemory) throws FactException {
        this.getRete().assertObject((FactHandleImpl)handle, context, workingMemory);
    }

    void modifyObject(FactHandle handle, PropagationContext context, WorkingMemoryImpl workingMemory) throws FactException {
        this.getRete().modifyObject((FactHandleImpl)handle, context, workingMemory);
    }

    void retractObject(FactHandle handle, PropagationContext context, WorkingMemoryImpl workingMemory) throws FactException {
        this.getRete().retractObject((FactHandleImpl)handle, context, workingMemory);
    }

    public Package[] getPackages() {
        return this.pkgs.values().toArray(new Package[this.pkgs.size()]);
    }

    public Map getGlobals() {
        return this.globals;
    }

    public void addPackage(Package newPkg) throws PackageIntegrationException {
        newPkg.checkValidity();
        Package pkg = (Package)this.pkgs.get(newPkg.getName());
        Iterator it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            WorkingMemoryImpl workingMemory = (WorkingMemoryImpl)it.next();
            workingMemory.getLock().lock();
        }
        if (pkg != null) {
            this.mergePackage(pkg, newPkg);
        } else {
            this.pkgs.put(newPkg.getName(), newPkg);
        }
        Map newGlobals = newPkg.getGlobals();
        Iterator it2 = newGlobals.keySet().iterator();
        while (it2.hasNext()) {
            String identifier = (String)it2.next();
            Class type = (Class)newGlobals.get(identifier);
            if (!this.globals.containsKey(identifier) || this.globals.get(identifier).equals(type)) continue;
            throw new PackageIntegrationException(pkg);
        }
        this.globals.putAll(newGlobals);
        Rule[] rules = newPkg.getRules();
        for (int i = 0; i < rules.length; ++i) {
            this.addRule(rules[i]);
        }
        this.packageClassLoader.addClassLoader(newPkg.getPackageCompilationData().getClassLoader());
        Iterator it3 = this.workingMemories.keySet().iterator();
        while (it3.hasNext()) {
            WorkingMemoryImpl workingMemory = (WorkingMemoryImpl)it3.next();
            workingMemory.fireAllRules();
            workingMemory.getLock().unlock();
        }
    }

    private void mergePackage(Package pkg, Package newPkg) throws PackageIntegrationException {
        Map globals = pkg.getGlobals();
        List imports = pkg.getImports();
        PackageCompilationData compilationData = pkg.getPackageCompilationData();
        PackageCompilationData newCompilationData = newPkg.getPackageCompilationData();
        String[] files = newCompilationData.list();
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            compilationData.write(files[i], newCompilationData.read(files[i]));
        }
        imports.addAll(newPkg.getImports());
        compilationData.putAllInvokers(newCompilationData.getInvokers());
        Iterator it = newPkg.getGlobals().keySet().iterator();
        while (it.hasNext()) {
            String identifier = (String)it.next();
            Class type = (Class)globals.get(identifier);
            if (!globals.containsKey(identifier) || globals.get(identifier).equals(type)) continue;
            throw new PackageIntegrationException("Unable to merge new Package", newPkg);
        }
        globals.putAll(newPkg.getGlobals());
    }

    private void addRule(Rule rule) throws InvalidPatternException {
        if (!rule.isValid()) {
            throw new IllegalArgumentException("The rule called " + rule.getName() + " is not valid. Check for compile errors reported.");
        }
        this.reteooBuilder.addRule(rule);
    }

    public void removePackage(String packageName) {
        Package pkg = (Package)this.pkgs.get(packageName);
        Iterator it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            WorkingMemoryImpl workingMemory = (WorkingMemoryImpl)it.next();
            workingMemory.getLock().lock();
        }
        Rule[] rules = pkg.getRules();
        for (int i = 0; i < rules.length; ++i) {
            this.removeRule(rules[i]);
        }
        this.packageClassLoader.removeClassLoader(pkg.getPackageCompilationData().getClassLoader());
        pkg.clear();
        HashSet referencedGlobals = new HashSet();
        Iterator<Object> it2 = this.pkgs.values().iterator();
        while (it2.hasNext()) {
            Package pkgref = (Package)it2.next();
            if (pkgref == pkg) continue;
            referencedGlobals.addAll(pkgref.getGlobals().keySet());
        }
        it2 = pkg.getGlobals().keySet().iterator();
        while (it2.hasNext()) {
            String globalName = (String)it2.next();
            if (referencedGlobals.contains(globalName)) continue;
            this.globals.remove(globalName);
        }
        this.pkgs.remove(pkg.getName());
        it2 = this.workingMemories.keySet().iterator();
        while (it2.hasNext()) {
            WorkingMemoryImpl workingMemory = (WorkingMemoryImpl)it2.next();
            workingMemory.getLock().unlock();
        }
    }

    public void removeRule(String packageName, String ruleName) {
        WorkingMemoryImpl workingMemory;
        Package pkg = (Package)this.pkgs.get(packageName);
        Rule rule = pkg.getRule(ruleName);
        Iterator it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            workingMemory = (WorkingMemoryImpl)it.next();
            workingMemory.getLock().lock();
        }
        this.removeRule(rule);
        pkg.removeRule(rule);
        it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            workingMemory = (WorkingMemoryImpl)it.next();
            workingMemory.getLock().unlock();
        }
    }

    private void removeRule(Rule rule) {
        this.reteooBuilder.removeRule(rule);
    }

    public Set getWorkingMemories() {
        return this.workingMemories.keySet();
    }
}

